/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.test;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.ws.Service;
import javax.xml.ws.handler.HandlerResolver;
import org.apache.commons.validator.routines.InetAddressValidator;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.wsf.test.AppclientHelper;

public class JBossWSTestHelper {
    private static final String SYSPROP_JBOSSWS_INTEGRATION_TARGET = "jbossws.integration.target";
    private static final String SYSPROP_JBOSS_BIND_ADDRESS = "jboss.bind.address";
    private static final String SYSPROP_JBOSS_REMOTING_PROTOCOL = "jboss.remoting.protocol";
    private static final String SYSPROP_INITIAL_CONTEXT_FACTORY = "jboss.initial.context.factory";
    private static final String SYSPROP_TEST_ARCHIVE_DIRECTORY = "test.archive.directory";
    private static final String SYSPROP_TEST_RESOURCES_DIRECTORY = "test.resources.directory";
    private static final String SYSPROP_DEFAULT_CONTAINER_QUALIFIER = "default.container.qualifier";
    private static final String SYSPROP_DEFAULT_CONTAINER_GROUP_QUALIFIER = "default.container.group.qualifier";
    private static final String SYSPROP_CONTAINER_PORT_OFFSET_PREFIX = "port-offset.";
    private static final String SYSPROP_AS_SERVER_CONN_RETRIEVAL_ATTEMPTS = "test.as.server.connection.retrieval.attempts";
    private static final String TEST_USERNAME = "test.username";
    private static final String TEST_PASSWORD = "test.password";
    private static final int AS_SERVER_CONN_RETRIEVAL_ATTEMPTS = Integer.getInteger("test.as.server.connection.retrieval.attempts", 5);
    private static final String testArchiveDir = System.getProperty("test.archive.directory");
    private static final String testResourcesDir = System.getProperty("test.resources.directory");
    private static final String integrationTarget;
    private static final String implInfo;
    private static final String serverHost;
    private static final String remotingProtocol;
    private static final String initialContextFactory;
    private static WeakHashMap<ClassLoader, Hashtable<String, String>> containerEnvs;

    public static Process deployAppclient(String archive, OutputStream appclientOS, String ... appclientArgs) throws Exception {
        return AppclientHelper.deployAppclient(archive, appclientOS, appclientArgs);
    }

    public static void undeployAppclient(String archive, boolean awaitShutdown) throws Exception {
        AppclientHelper.undeployAppclient(archive, awaitShutdown);
    }

    public static boolean isTargetWildFly9() {
        String target = JBossWSTestHelper.getIntegrationTarget();
        return target.startsWith("wildfly9");
    }

    public static boolean isTargetWildFly10() {
        String target = JBossWSTestHelper.getIntegrationTarget();
        return target.startsWith("wildfly10");
    }

    public static boolean isIntegrationCXF() {
        String vendor = JBossWSTestHelper.getImplementationInfo();
        return vendor.toLowerCase().indexOf("apache") != -1;
    }

    private static String getImplementationInfo() {
        return implInfo;
    }

    private static Object getImplementationObject() {
        Service service = Service.create((QName)new QName("dummyService"));
        HandlerResolver obj = service.getHandlerResolver();
        if (obj == null) {
            service.addPort(new QName("dummyPort"), "http://schemas.xmlsoap.org/wsdl/soap/http", "http://dummy-address");
            obj = service.createDispatch(new QName("dummyPort"), Source.class, Service.Mode.PAYLOAD);
        }
        return obj;
    }

    public static String getRemotingProtocol() {
        return remotingProtocol;
    }

    public static String getInitialContextFactory() {
        return initialContextFactory;
    }

    public static String getServerHost() {
        return JBossWSTestHelper.toIPv6URLFormat(serverHost);
    }

    public static int getServerPort() {
        return JBossWSTestHelper.getServerPort(null, null);
    }

    public static int getServerPort(String groupQualifier, String containerQualifier) {
        return 8080 + JBossWSTestHelper.getContainerPortOffset(groupQualifier, containerQualifier);
    }

    public static int getSecureServerPort(String groupQualifier, String containerQualifier) {
        return 8443 + JBossWSTestHelper.getContainerPortOffset(groupQualifier, containerQualifier);
    }

    protected static int getContainerPortOffset(String groupQualifier, String containerQualifier) {
        String offset;
        Hashtable<String, String> env = JBossWSTestHelper.getContainerEnvironment();
        if (groupQualifier == null) {
            groupQualifier = env.get(SYSPROP_DEFAULT_CONTAINER_GROUP_QUALIFIER);
        }
        if (containerQualifier == null) {
            containerQualifier = env.get(SYSPROP_DEFAULT_CONTAINER_QUALIFIER);
        }
        return (offset = env.get(SYSPROP_CONTAINER_PORT_OFFSET_PREFIX + groupQualifier + "." + containerQualifier)) != null ? Integer.valueOf(offset) : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Hashtable<String, String> getContainerEnvironment() {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        WeakHashMap<ClassLoader, Hashtable<String, String>> weakHashMap = containerEnvs;
        synchronized (weakHashMap) {
            Hashtable<String, String> env = containerEnvs.get(tccl);
            if (env == null) {
                env = new Hashtable();
                InputStream is = tccl.getResourceAsStream("container.properties");
                try {
                    if (is != null) {
                        Properties props = new Properties();
                        props.load(is);
                        for (Map.Entry<Object, Object> entry : props.entrySet()) {
                            env.put((String)entry.getKey(), (String)entry.getValue());
                        }
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                containerEnvs.put(tccl, env);
            }
            return env;
        }
    }

    public static String toIPv6URLFormat(String host) {
        try {
            boolean isIPv6Address;
            if (host.startsWith("[") || host.startsWith(":")) {
                if (System.getProperty("java.net.preferIPv4Stack") == null) {
                    throw new IllegalStateException("always provide java.net.preferIPv4Stack JVM property when using IPv6 address format");
                }
                if (System.getProperty("java.net.preferIPv6Addresses") == null) {
                    throw new IllegalStateException("always provide java.net.preferIPv6Addresses JVM property when using IPv6 address format");
                }
            }
            boolean isIPv6Literal = (isIPv6Address = InetAddress.getByName(host) instanceof Inet6Address) && InetAddressValidator.getInstance().isValidInet6Address(host.replaceAll("^\\[(.*)\\]$", "$1"));
            boolean isIPv6LiteralFormattedForURI = isIPv6Literal && host.startsWith("[");
            return isIPv6Literal && !isIPv6LiteralFormattedForURI ? "[" + host + "]" : host;
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    public static MBeanServerConnection getServer() {
        return JBossWSTestHelper.getServer(null, null);
    }

    public static MBeanServerConnection getServer(String groupQualifier, String containerQualifier) {
        int portOffset = JBossWSTestHelper.getContainerPortOffset(groupQualifier, containerQualifier);
        String integrationTarget = JBossWSTestHelper.getIntegrationTarget();
        if (!integrationTarget.startsWith("wildfly")) {
            throw new IllegalStateException("Unsupported target container: " + integrationTarget);
        }
        MBeanServerConnection server = JBossWSTestHelper.getServerConnection("service:jmx:http-remoting-jmx://" + JBossWSTestHelper.getServerHost() + ":" + (9990 + portOffset));
        return server;
    }

    private static MBeanServerConnection getServerConnection(String jmxServiceUrl) {
        String urlString = System.getProperty("jmx.service.url", jmxServiceUrl);
        JMXServiceURL serviceURL = null;
        JMXConnector connector = null;
        try {
            serviceURL = new JMXServiceURL(urlString);
        }
        catch (MalformedURLException e1) {
            throw new IllegalStateException(e1);
        }
        for (int i = 0; i < AS_SERVER_CONN_RETRIEVAL_ATTEMPTS && connector == null; ++i) {
            try {
                connector = JMXConnectorFactory.connect(serviceURL, null);
                continue;
            }
            catch (IOException ex) {
                throw new IllegalStateException("Cannot obtain MBeanServerConnection to: " + urlString, ex);
            }
            catch (RuntimeException e) {
                if (e.getMessage().contains("WAITING") && i < AS_SERVER_CONN_RETRIEVAL_ATTEMPTS - 1) continue;
                throw e;
            }
        }
        try {
            return connector.getMBeanServerConnection();
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot obtain MBeanServerConnection to: " + urlString, e);
        }
    }

    public static String getIntegrationTarget() {
        return integrationTarget;
    }

    public static URL getArchiveURL(String archive) throws MalformedURLException {
        return JBossWSTestHelper.getArchiveFile(archive).toURI().toURL();
    }

    public static File getArchiveFile(String archive) {
        File file = new File(archive);
        if (file.exists()) {
            return file;
        }
        file = new File(JBossWSTestHelper.getTestArchiveDir() + "/" + archive);
        if (file.exists()) {
            return file;
        }
        String notSet = JBossWSTestHelper.getTestArchiveDir() == null ? " System property 'test.archive.directory' not set." : "";
        throw new IllegalArgumentException("Cannot obtain '" + JBossWSTestHelper.getTestArchiveDir() + "/" + archive + "'." + notSet);
    }

    public static URL getResourceURL(String resource) throws MalformedURLException {
        return JBossWSTestHelper.getResourceFile(resource).toURI().toURL();
    }

    public static File getResourceFile(String resource) {
        File file = new File(resource);
        if (file.exists()) {
            return file;
        }
        file = new File(JBossWSTestHelper.getTestResourcesDir() + "/" + resource);
        if (file.exists()) {
            return file;
        }
        String notSet = JBossWSTestHelper.getTestResourcesDir() == null ? " System property 'test.resources.directory' not set." : "";
        throw new IllegalArgumentException("Cannot obtain '" + JBossWSTestHelper.getTestResourcesDir() + "/" + resource + "'." + notSet);
    }

    public static String getTestArchiveDir() {
        return testArchiveDir;
    }

    public static String getTestResourcesDir() {
        return testResourcesDir;
    }

    public static String getTestUsername() {
        String prop = System.getProperty(TEST_USERNAME);
        if (prop == null || "".equals(prop) || "${test.username}".equals(prop)) {
            prop = "kermit";
        }
        return prop;
    }

    public static String getTestPassword() {
        String prop = System.getProperty(TEST_PASSWORD);
        if (prop == null || "".equals(prop) || "${test.password}".equals(prop)) {
            prop = "thefrog";
        }
        return prop;
    }

    public static void writeToFile(Archive archive) {
        File archiveDir = JBossWSTestHelper.assertArchiveDirExists();
        File file = new File(archiveDir, archive.getName());
        ((ZipExporter)archive.as(ZipExporter.class)).exportTo(file, true);
    }

    public static File assertArchiveDirExists() {
        File archiveDir = new File(testArchiveDir);
        if (!archiveDir.exists()) {
            if (testArchiveDir == null) {
                throw new IllegalArgumentException("Cannot create archive - system property 'test.archive.directory' not set.");
            }
            if (!archiveDir.mkdirs() && !archiveDir.exists()) {
                throw new IllegalArgumentException("Cannot create archive - can not create test archive directory '" + archiveDir.getAbsolutePath() + "'");
            }
        }
        return archiveDir;
    }

    public static String writeToFile(BaseDeployment<?> ... deps) {
        if (deps == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (BaseDeployment<?> dep : deps) {
            sb.append(dep.writeToFile().getName());
            sb.append(" ");
        }
        return sb.toString().trim();
    }

    static {
        serverHost = System.getProperty(SYSPROP_JBOSS_BIND_ADDRESS, "localhost");
        remotingProtocol = System.getProperty(SYSPROP_JBOSS_REMOTING_PROTOCOL);
        initialContextFactory = System.getProperty(SYSPROP_INITIAL_CONTEXT_FACTORY);
        containerEnvs = new WeakHashMap();
        integrationTarget = System.getProperty(SYSPROP_JBOSSWS_INTEGRATION_TARGET);
        if (integrationTarget == null) {
            throw new IllegalStateException("Cannot obtain system property: jbossws.integration.target");
        }
        Object obj = JBossWSTestHelper.getImplementationObject();
        implInfo = obj.getClass().getPackage().getName();
    }

    public static abstract class JarDeployment
    extends BaseDeployment<JavaArchive> {
        public JarDeployment(String name) {
            super(JavaArchive.class, name);
        }
    }

    public static abstract class BaseDeployment<T extends Archive<T>> {
        protected T archive;

        public BaseDeployment(Class<T> clazz, String name) {
            this.archive = (Archive)ShrinkWrap.create(clazz, (String)name);
        }

        public T create() {
            return this.archive;
        }

        public T writeToFile() {
            File archiveDir = JBossWSTestHelper.assertArchiveDirExists();
            File file = new File(archiveDir, this.archive.getName());
            ((ZipExporter)this.archive.as(ZipExporter.class)).exportTo(file, true);
            return this.archive;
        }

        public String getName() {
            return this.archive.getName();
        }
    }
}

