/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.test;

import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import javax.crypto.Cipher;
import org.jboss.wsf.stack.cxf.client.configuration.SecurityProviderConfig;

public class CryptoCheckHelper {
    public static void main(String[] args) throws Exception {
        System.out.println("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        System.out.println("JCE unlimited strength cryptography:   " + (!CryptoCheckHelper.isUnlimitedStrengthCryptographyAvailable() ? "NOT " : "") + "AVAILABLE");
        Provider p = CryptoCheckHelper.getBCProviderFromInstalledSecurityProviders();
        if (p != null) {
            System.out.println("Bouncy Castle JCE Provider:            AVAILABLE - INSTALLED (ver: " + p.getVersion() + ", " + p.getClass().getProtectionDomain().getCodeSource().getLocation() + ")");
        } else {
            p = CryptoCheckHelper.getBCProviderFromClassPath();
            if (p != null) {
                System.out.println("Bouncy Castle JCE Provider:            AVAILABLE - ON CLASSPATH (ver: " + p.getVersion() + ", " + p.getClass().getProtectionDomain().getCodeSource().getLocation() + ")");
            } else {
                System.out.println("Bouncy Castle JCE Provider:            NOT AVAILABLE");
            }
        }
        System.out.println("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
    }

    public static Provider getBCProviderFromInstalledSecurityProviders() {
        return Security.getProvider("BC");
    }

    public static Provider getBCProviderFromClassPath() {
        try {
            Class<?> clazz = SecurityProviderConfig.class.getClassLoader().loadClass("org.bouncycastle.jce.provider.BouncyCastleProvider");
            return (Provider)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static boolean isBouncyCastleAvailable() {
        return CryptoCheckHelper.getBCProviderFromClassPath() != null || CryptoCheckHelper.getBCProviderFromInstalledSecurityProviders() != null;
    }

    public static boolean isUnlimitedStrengthCryptographyAvailable() {
        try {
            return Cipher.getMaxAllowedKeyLength("RC5") >= 256;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static Exception checkAndWrapException(Exception e) throws Exception {
        if (!CryptoCheckHelper.isBouncyCastleAvailable()) {
            return new Exception("Bouncy Castle JCE provider does not seem to be properly installed; either install it or run the testsuite with -Dexclude-integration-tests-BC-related=true to exclude this test.", e);
        }
        if (!CryptoCheckHelper.isUnlimitedStrengthCryptographyAvailable()) {
            return new Exception("JCE unlimited strength cryptography extension does not seem to be properly installed; either install it or run the testsuite with '-Dexclude-integration-tests-unlimited-strength-related=true' to exclude this test.", e);
        }
        if (e.getCause() != null && e.getCause().getClass().getName().contains("SoapFault") && e.getMessage() != null && e.getMessage().contains("algorithm")) {
            return new Exception("Please check for Bouncy Castle JCE provider and JCE unlimited strenght cryptography extension availability on server side.", e);
        }
        return e;
    }
}

