/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.test;

import org.junit.Assume;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class EnableOnJDK
implements TestRule {
    public static final EnableOnJDK ON_JDK17 = new EnableOnJDK("17");
    private String version;

    public EnableOnJDK(String version) {
        this.version = version;
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){
            boolean enabled = false;

            public void evaluate() throws Throwable {
                String jdkVersion = System.getProperty("java.version", "0");
                if (jdkVersion.startsWith(EnableOnJDK.this.version)) {
                    this.enabled = true;
                }
                Assume.assumeTrue((String)(description.getClassName() + " is enabled for JDK (" + EnableOnJDK.this.version + ")"), (boolean)this.enabled);
                base.evaluate();
            }
        };
    }
}

