/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.jboss.test.ws.jaxws.jbws2074.usecase1.service;

import jakarta.jws.HandlerChain;
import jakarta.jws.WebMethod;
import jakarta.jws.WebService;

import org.jboss.logging.Logger;

@WebService
(
   name = "POJO",
   serviceName = "POJOService",
   targetNamespace = "http://ws.jboss.org/jbws2074",
   endpointInterface = "org.jboss.test.ws.jaxws.jbws2074.usecase1.service.POJOIface"
)
@HandlerChain(file = "jaxws-service-handlers.xml")
public class POJOImpl implements POJOIface
{
   private static Logger log = Logger.getLogger(POJOImpl.class);

   @WebMethod
   public String echo(String msg)
   {
      log.info("echo: " + msg);
      return msg + ":POJOImpl";
   }
}
