/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.jboss.test.ws.jaxws.jbws2942;

import java.io.StringWriter;

import javax.xml.transform.stream.StreamResult;
import jakarta.xml.ws.wsaddressing.W3CEndpointReference;
import jakarta.xml.ws.wsaddressing.W3CEndpointReferenceBuilder;

import org.jboss.wsf.test.JBossWSTest;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.Test;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.arquillian.container.test.api.RunAsClient;

/**
 * [JBWS-2942] Do not add empty Metadata tag to EndpointReference.
 *
 * @author <a href="mailto:ropalka@redhat.com">Richard Opalka</a>
 */
@ExtendWith(ArquillianExtension.class)
public final class JBWS2942TestCase extends JBossWSTest
{
   @Test
   @RunAsClient
   public void testEmptyMetadataDropped() 
   {
      W3CEndpointReferenceBuilder builder = new W3CEndpointReferenceBuilder();
      builder.address("http://bar");
      W3CEndpointReference epr = builder.build();
      StringWriter writer = new StringWriter();
      epr.writeTo(new StreamResult(writer));
      String eprString = writer.toString();
      assertTrue(eprString.contains("EndpointReference"));
      assertTrue(eprString.contains("Address"));
      assertFalse(eprString.contains("Metadata"));
   }
   
}
