/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.jboss.test.ws.jaxws.samples.exception.server;

import jakarta.xml.ws.WebFault;

/**
 * A mach application exception
 *
 * @author <a href="jason.greene@jboss.com">Jason T. Greene</a>
 */
@WebFault(faultBean="org.jboss.test.ws.jaxws.samples.exception.server.jaxws.UserExceptionBean")
public class UserException extends Exception
{

   private static final long serialVersionUID = -4005685987159367861L;
   private final int errorCode;
   private final String errorCategory;

   public UserException(String errorCategory, int errorCode, String message)
   {
      super(message);

      this.errorCategory = errorCategory;
      this.errorCode = errorCode;
   }

   public String getErrorCategory()
   {
      return errorCategory;
   }

   public int getErrorCode()
   {
      return errorCode;
   }
}
