/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.jboss.test.ws.jaxws.samples.webresult;

import jakarta.jws.WebMethod;
import jakarta.jws.WebParam;
import jakarta.jws.WebResult;
import jakarta.jws.WebService;
import jakarta.jws.soap.SOAPBinding;
import jakarta.jws.soap.SOAPBinding.Style;

/**
 * This class was generated by the JAXWS SI.
 * JAX-WS RI 2.0-b26-ea3
 * Generated source version: 2.0
 */
@WebService(name = "CustomerService", targetNamespace = "http://webresult.samples.jaxws.ws.test.jboss.org/", wsdlLocation = "META-INF/wsdl/CustomerService.wsdl")
@SOAPBinding(style = Style.RPC)
public interface CustomerService {

    /**
     * 
     * @param address
     * @param firstName
     * @param lastName
     * @return
     *     returns org.jboss.test.ws.jaxws.samples.webresult.CustomerRecord
     */
    @WebMethod
    @WebResult(name = "CustomerRecord", targetNamespace = "http://webresult.samples.jaxws.ws.test.jboss.org/", partName = "CustomerRecord")
    public CustomerRecord locateCustomer(
        @WebParam(name = "FirstName", partName = "FirstName")
        String firstName,
        @WebParam(name = "LastName", partName = "LastName")
        String lastName,
        @WebParam(name = "Address", partName = "Address")
        USAddress address);

}
