/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.common.addressing;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.logging.Logger;
import org.jboss.wsf.common.addressing.MAPBuilder;
import org.jboss.wsf.spi.util.ServiceLoader;

public abstract class MAPBuilderFactory {
    private static final String CLASSLOADER_PROVIDER = "org.jboss.wsf.spi.classloading.ClassLoaderProvider";
    private static final String CLASSLOADER_PROVIDER_GET_METHOD = "getDefaultProvider";
    private static final String CLASSLOADER_PROVIDER_GET_CL_METHOD = "getServerIntegrationClassLoader";
    private static final String JBOSSWS_SPI_MODULE = "org.jboss.ws.spi";

    public static MAPBuilderFactory getInstance() {
        return MAPBuilderFactory.getInstance(MAPBuilderFactory.getServerIntegrationClassLoader());
    }

    public static MAPBuilderFactory getInstance(ClassLoader loader) {
        return (MAPBuilderFactory)ServiceLoader.loadService(MAPBuilderFactory.class.getName(), null, loader);
    }

    public abstract MAPBuilder getBuilderInstance();

    private static ClassLoader getServerIntegrationClassLoader() {
        ClassLoader cl = null;
        try {
            ClassLoader spiLoader = MAPBuilderFactory.getSPIClassLoader();
            if (spiLoader != null) {
                Class<?> clazz = spiLoader.loadClass(CLASSLOADER_PROVIDER);
                Object clProvider = clazz.getMethod(CLASSLOADER_PROVIDER_GET_METHOD, new Class[0]).invoke(null, new Object[0]);
                cl = (ClassLoader)clazz.getMethod(CLASSLOADER_PROVIDER_GET_CL_METHOD, new Class[0]).invoke(clProvider, new Object[0]);
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return cl != null ? cl : MAPBuilderFactory.getContextClassLoader();
    }

    private static ClassLoader getSPIClassLoader() {
        ClassLoader moduleClassLoader;
        block2: {
            moduleClassLoader = null;
            try {
                Class<?> moduleClass = Class.forName("org.jboss.modules.Module");
                Class<?> moduleIdentifierClass = Class.forName("org.jboss.modules.ModuleIdentifier");
                Class<?> moduleLoaderClass = Class.forName("org.jboss.modules.ModuleLoader");
                Object moduleLoader = moduleClass.getMethod("getBootModuleLoader", new Class[0]).invoke(null, new Object[0]);
                Object moduleIdentifier = moduleIdentifierClass.getMethod("create", String.class).invoke(null, JBOSSWS_SPI_MODULE);
                Object module = moduleLoaderClass.getMethod("loadModule", moduleIdentifierClass).invoke(moduleLoader, moduleIdentifier);
                moduleClassLoader = (ClassLoader)moduleClass.getMethod("getClassLoader", new Class[0]).invoke(module, new Object[0]);
            }
            catch (Exception e) {
                Logger log = Logger.getLogger(MAPBuilderFactory.class);
                if (!log.isTraceEnabled()) break block2;
                log.trace((Object)"Could not get org.jboss.ws.spi module classloader: ", (Throwable)e);
            }
        }
        return moduleClassLoader;
    }

    static ClassLoader getContextClassLoader() {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }
}

