/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.deployment;

import org.jboss.logging.Logger;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.LifecycleHandler;
import org.jboss.wsf.spi.invocation.InvocationHandler;

public class DefaultLifecycleHandler
implements LifecycleHandler {
    protected final Logger log = Logger.getLogger(this.getClass());

    public void start(Endpoint ep) {
        Endpoint.EndpointState state;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Start: " + ep.getName()));
        }
        if ((state = ep.getState()) != Endpoint.EndpointState.UNDEFINED) {
            this.log.error((Object)("Cannot start endpoint in state: " + state));
        } else {
            InvocationHandler invHandler;
            if (ep.getEndpointMetrics() != null) {
                ep.getEndpointMetrics().start();
            }
            if ((invHandler = ep.getInvocationHandler()) == null) {
                throw new IllegalStateException("Invocation handler not available");
            }
            invHandler.init(ep);
            ep.setState(Endpoint.EndpointState.STARTED);
        }
    }

    public void stop(Endpoint ep) {
        Endpoint.EndpointState state;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Stop: " + ep.getName()));
        }
        if ((state = ep.getState()) != Endpoint.EndpointState.STARTED) {
            this.log.error((Object)("Cannot stop endpoint in state: " + state));
        } else {
            if (ep.getEndpointMetrics() != null) {
                ep.getEndpointMetrics().stop();
            }
            ep.setState(Endpoint.EndpointState.STOPPED);
        }
    }
}

