/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.management;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;
import org.jboss.logging.Logger;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.management.EndpointRegistry;
import org.jboss.wsf.spi.management.EndpointResolver;

public class DefaultEndpointRegistry
implements EndpointRegistry {
    private static final Logger log = Logger.getLogger(DefaultEndpointRegistry.class);
    private Map<ObjectName, Endpoint> endpoints = new HashMap<ObjectName, Endpoint>();

    public Endpoint getEndpoint(ObjectName epName) {
        if (epName == null) {
            throw new IllegalArgumentException("Endpoint name cannot be null");
        }
        if (!this.isRegistered(epName)) {
            throw new IllegalStateException("Endpoint not registered: " + epName);
        }
        Endpoint endpoint = this.endpoints.get(epName);
        return endpoint;
    }

    public Endpoint resolve(EndpointResolver resolver) {
        return resolver.query(this.endpoints.values().iterator());
    }

    public boolean isRegistered(ObjectName epName) {
        if (epName == null) {
            throw new IllegalArgumentException("Endpoint name cannot be null");
        }
        return this.endpoints.get(epName) != null;
    }

    public Set<ObjectName> getEndpoints() {
        return this.endpoints.keySet();
    }

    public void register(Endpoint endpoint) {
        if (endpoint == null) {
            throw new IllegalArgumentException("Endpoint cannot be null");
        }
        ObjectName epName = endpoint.getName();
        if (epName == null) {
            throw new IllegalStateException("Endpoint name cannot be null for: " + endpoint);
        }
        if (this.isRegistered(epName)) {
            throw new IllegalStateException("Endpoint already registered: " + epName);
        }
        log.info((Object)("register: " + epName));
        this.endpoints.put(epName, endpoint);
    }

    public void unregister(Endpoint endpoint) {
        if (endpoint == null) {
            throw new IllegalArgumentException("Endpoint cannot be null");
        }
        ObjectName epName = endpoint.getName();
        if (!this.isRegistered(epName)) {
            throw new IllegalStateException("Endpoint not registered: " + epName);
        }
        log.info((Object)("remove: " + epName));
        this.endpoints.remove(epName);
    }
}

