/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.serviceref;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.naming.NamingException;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedServiceRefMetaData;

final class ServiceRefSerializer {
    static final String SERVICE_REF_META_DATA = "SERVICE_REF_META_DATA";

    private ServiceRefSerializer() {
    }

    static byte[] marshall(UnifiedServiceRefMetaData obj) throws NamingException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(obj);
            oos.close();
        }
        catch (IOException e) {
            throw new NamingException("Cannot marshall service ref meta data, cause: " + e.toString());
        }
        return baos.toByteArray();
    }

    static UnifiedServiceRefMetaData unmarshall(byte[] data) throws NamingException {
        UnifiedServiceRefMetaData sref;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            ObjectInputStream ois = new ObjectInputStream(bais);
            sref = (UnifiedServiceRefMetaData)ois.readObject();
            ois.close();
        }
        catch (IOException e) {
            throw new NamingException("Cannot unmarshall service ref meta data, cause: " + e.toString());
        }
        catch (ClassNotFoundException e) {
            throw new NamingException("Cannot unmarshall service ref meta data, cause: " + e.toString());
        }
        return sref;
    }
}

