/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jboss.ws.common.DOMUtils;
import org.jboss.ws.common.IOUtils;
import org.jboss.ws.common.Loggers;
import org.jboss.ws.common.Messages;
import org.jboss.ws.common.integration.WSHelper;
import org.jboss.ws.common.management.AbstractServerConfig;
import org.jboss.ws.common.utils.ResourceURL;
import org.jboss.ws.common.utils.SecurityActions;
import org.jboss.wsf.spi.deployment.ArchiveDeployment;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.management.ServerConfig;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractWSDLFilePublisher {
    protected ArchiveDeployment dep;
    protected String expLocation;
    protected ServerConfig serverConfig;
    private static DocumentBuilder builder;

    public AbstractWSDLFilePublisher(ArchiveDeployment dep) {
        this.dep = dep;
        this.serverConfig = (ServerConfig)dep.getAttachment(ServerConfig.class);
        if (this.serverConfig == null) {
            this.serverConfig = AbstractServerConfig.getServerIntegrationServerConfig();
        }
        this.expLocation = WSHelper.isJseDeployment((Deployment)dep) || WSHelper.isWarArchive((Deployment)dep) ? "WEB-INF/wsdl/" : "META-INF/wsdl/";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized DocumentBuilder getDocumentBuilder() {
        if (builder == null) {
            ClassLoader classLoader = SecurityActions.getContextClassLoader();
            SecurityActions.setContextClassLoader(AbstractWSDLFilePublisher.class.getClassLoader());
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setValidating(false);
                factory.setNamespaceAware(true);
                factory.setExpandEntityReferences(false);
                try {
                    factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                }
                catch (ParserConfigurationException pce) {
                    Loggers.DEPLOYMENT_LOGGER.error(pce);
                }
                builder = DOMUtils.newDocumentBuilder(factory);
            }
            finally {
                SecurityActions.setContextClassLoader(classLoader);
            }
        }
        return builder;
    }

    protected void publishWsdlImports(URL parentURL, Definition parentDefinition, List<String> published) throws Exception {
        this.publishWsdlImports(parentURL, parentDefinition, published, this.expLocation);
    }

    protected void publishWsdlImports(URL parentURL, Definition parentDefinition, List<String> published, String expLocation) throws Exception {
        String baseURI = parentURL.toExternalForm();
        Iterator it = parentDefinition.getImports().values().iterator();
        while (it.hasNext()) {
            for (Import wsdlImport : (List)it.next()) {
                String locationURI = wsdlImport.getLocationURI();
                Definition subdef = wsdlImport.getDefinition();
                if (locationURI.startsWith("http://") || published.contains(locationURI)) continue;
                published.add(locationURI);
                URL targetURL = new URL(baseURI.substring(0, baseURI.lastIndexOf("/") + 1) + locationURI);
                File targetFile = new File(targetURL.getFile());
                targetFile.getParentFile().mkdirs();
                WSDLFactory wsdlFactory = WSDLFactory.newInstance();
                WSDLWriter wsdlWriter = wsdlFactory.newWSDLWriter();
                FileWriter fw = new FileWriter(targetFile);
                wsdlWriter.writeWSDL(subdef, (Writer)fw);
                fw.close();
                Loggers.DEPLOYMENT_LOGGER.wsdlImportPublishedTo(targetURL);
                this.publishWsdlImports(targetURL, subdef, published, expLocation);
                Element subdoc = DOMUtils.parse(targetURL.openStream(), AbstractWSDLFilePublisher.getDocumentBuilder());
                this.publishSchemaImports(targetURL, subdoc, published, expLocation);
            }
        }
    }

    protected void publishSchemaImports(URL parentURL, Element element, List<String> published) throws Exception {
        this.publishSchemaImports(parentURL, element, published, this.expLocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void publishSchemaImports(URL parentURL, Element element, List<String> published, String expLocation) throws Exception {
        String baseURI = parentURL.toExternalForm();
        Iterator it = DOMUtils.getChildElements((Node)element);
        while (it.hasNext()) {
            Element childElement = (Element)it.next();
            if ("import".equals(childElement.getLocalName()) || "include".equals(childElement.getLocalName())) {
                String schemaLocation = childElement.getAttribute("schemaLocation");
                if (schemaLocation.length() <= 0 || schemaLocation.startsWith("http://") || published.contains(schemaLocation)) continue;
                published.add(schemaLocation);
                URL xsdURL = new URL(baseURI.substring(0, baseURI.lastIndexOf("/") + 1) + schemaLocation);
                File targetFile = new File(xsdURL.getFile());
                targetFile.getParentFile().mkdirs();
                String deploymentName = this.dep.getCanonicalName();
                int index = baseURI.indexOf(deploymentName) + 1;
                String resourcePath = baseURI.substring(index + deploymentName.length());
                resourcePath = resourcePath.substring(0, resourcePath.lastIndexOf("/") + 1);
                resourcePath = expLocation + resourcePath + schemaLocation;
                while (resourcePath.indexOf("//") != -1) {
                    resourcePath = resourcePath.replace("//", "/");
                }
                URL resourceURL = this.dep.getResourceResolver().resolve(resourcePath);
                InputStream is = new ResourceURL(resourceURL).openStream();
                if (is == null) {
                    throw Messages.MESSAGES.cannotFindSchemaImportInDeployment(resourcePath, deploymentName);
                }
                FileOutputStream fos = null;
                try {
                    fos = new FileOutputStream(targetFile);
                    IOUtils.copyStream(fos, is);
                }
                finally {
                    if (fos != null) {
                        fos.close();
                    }
                }
                Loggers.DEPLOYMENT_LOGGER.xmlSchemaImportPublishedTo(xsdURL);
                Element subdoc = DOMUtils.parse(xsdURL.openStream(), AbstractWSDLFilePublisher.getDocumentBuilder());
                this.publishSchemaImports(xsdURL, subdoc, published, expLocation);
                continue;
            }
            this.publishSchemaImports(parentURL, childElement, published, expLocation);
        }
    }

    public void unpublishWsdlFiles() throws IOException {
        String deploymentDir = this.dep.getParent() != null ? this.dep.getParent().getSimpleName() : this.dep.getSimpleName();
        File serviceDir = new File(this.serverConfig.getServerDataDir().getCanonicalPath() + "/wsdl/" + deploymentDir);
        this.deleteWsdlPublishDirectory(serviceDir);
    }

    protected void deleteWsdlPublishDirectory(File dir) throws IOException {
        String[] files = dir.list();
        for (int i = 0; files != null && i < files.length; ++i) {
            String fileName = files[i];
            File file = new File(dir + "/" + fileName);
            if (file.isDirectory()) {
                this.deleteWsdlPublishDirectory(file);
                continue;
            }
            if (file.delete()) continue;
            Loggers.DEPLOYMENT_LOGGER.cannotDeletePublishedWsdlDoc(file.toURI().toURL());
        }
        dir.delete();
    }
}

