/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.ws.jaxws.jbws1822;

import java.net.URL;

import javax.xml.namespace.QName;
import javax.xml.ws.Service;

import junit.framework.Test;

import org.jboss.test.ws.jaxws.jbws1822.webservice.EJB3RemoteIface;
import org.jboss.wsf.test.JBossWSTest;
import org.jboss.wsf.test.JBossWSTestSetup;

/**
 * [JBWS-1822] Cannot find service endpoint target
 *
 * @author richard.opalka@jboss.com
 *
 * @since Jan 8, 2008
 */
public final class JBWS1822TestCase extends JBossWSTest
{
   public static Test suite()
   {
      return new JBossWSTestSetup(JBWS1822TestCase.class, "");
   }

   private EJB3RemoteIface getProxy() throws Exception
   {
      QName serviceName = new QName("http://jbossws.org/JBWS1822", "EndpointService");
      URL wsdlURL = new URL("http://" + getServerHost() + ":8080/jaxws-jbws1822?wsdl");

      Service service = Service.create(wsdlURL, serviceName);
      return (EJB3RemoteIface)service.getPort(EJB3RemoteIface.class);
   }
   
   public void testOneEjbModule() throws Exception
   {
      deploy("jaxws-jbws1822-one-ejb-module.ear");
      try
      {
         assertEquals(getProxy().getMessage(), "Injected hello message");
      }
      finally
      {
         undeploy("jaxws-jbws1822-one-ejb-module.ear");
      }
   }
   
   public void testTwoEjbModules() throws Exception
   {
      deploy("jaxws-jbws1822-two-ejb-modules.ear");
      try
      {
         assertEquals(getProxy().getMessage(), "Injected hello message");
      }
      finally
      {
         undeploy("jaxws-jbws1822-two-ejb-modules.ear");
      }
   }
   
}
