/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.ws.jaxws.samples.context;

import java.io.IOException;
import java.security.Principal;

import javax.annotation.Resource;
import javax.jws.WebMethod;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.jws.soap.SOAPBinding.Style;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.MessageContext;

import org.jboss.wsf.common.DOMUtils;
import org.jboss.wsf.common.DOMWriter;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

@WebService(name = "Endpoint", serviceName = "EndpointService", targetNamespace = "http://org.jboss.ws/jaxws/context")
@SOAPBinding(style = Style.RPC)
public class EndpointJSE
{
   @Resource
   WebServiceContext wsCtx;

   @WebMethod
   public String testGetMessageContext()
   {
      MessageContext msgContext = (MessageContext)wsCtx.getMessageContext();
      return msgContext == null ? "fail" : "pass";
   }

   @WebMethod
   public String testMessageContextProperties()
   {
      MessageContext msgContext = (MessageContext)wsCtx.getMessageContext();
      if (msgContext == null)
         return "fail";

      // Check standard jaxws properties
      InputSource wsdlSource = (InputSource)msgContext.get(MessageContext.WSDL_DESCRIPTION);
      QName service = (QName)msgContext.get(MessageContext.WSDL_SERVICE);
      QName portType = (QName)msgContext.get(MessageContext.WSDL_INTERFACE);
      QName port = (QName)msgContext.get(MessageContext.WSDL_PORT);
      QName operation = (QName)msgContext.get(MessageContext.WSDL_OPERATION);
      
      if (!service.equals(new QName("http://org.jboss.ws/jaxws/context", "EndpointService")))
         throw new WebServiceException("Invalid qname: " + service);
      if (!portType.equals(new QName("http://org.jboss.ws/jaxws/context", "Endpoint")))
         throw new WebServiceException("Invalid qname: " + portType);
      if (!port.equals(new QName("http://org.jboss.ws/jaxws/context", "EndpointPort")))
         throw new WebServiceException("Invalid qname: " + port);
      if (!operation.equals(new QName("http://org.jboss.ws/jaxws/context", "testMessageContextProperties")))
         throw new WebServiceException("Invalid qname: " + operation);

      try
      {
         Element root = DOMUtils.parse(wsdlSource);
         new DOMWriter(System.out).setPrettyprint(true).print(root);
      }
      catch (IOException ex)
      {
         throw new WebServiceException("Cannot parse MessageContext.WSDL_DESCRIPTION", ex);
      }

      return "pass";
   }

   @WebMethod
   public String testGetUserPrincipal()
   {
      Principal principal = wsCtx.getUserPrincipal();
      return principal.getName();
   }

   @WebMethod
   public boolean testIsUserInRole(String role)
   {
      return wsCtx.isUserInRole(role);
   }
}
