/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.framework.transport;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.logging.Logger;
import org.jboss.wsf.framework.transport.HttpDeamon;
import org.jboss.wsf.framework.transport.TJWSHttpDeamon;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.invocation.EndpointAssociation;
import org.jboss.wsf.spi.invocation.RequestHandler;
import org.jboss.wsf.spi.transport.HttpListenerRef;
import org.jboss.wsf.spi.transport.HttpSpec;
import org.jboss.wsf.spi.transport.ListenerRef;
import org.jboss.wsf.spi.transport.TransportManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpTransportManager
implements TransportManager<HttpSpec> {
    private HttpDeamon httpDeamon;
    public static final int DEFAULT_PORT = 20000;
    public static final String DEFAULT_HOST = "localhost";
    private int port;
    private String host;

    public HttpTransportManager(String host, int port) {
        this.host = host;
        this.port = port;
        this.httpDeamon = TJWSHttpDeamon.getInstance(20000);
        this.httpDeamon.start();
    }

    public HttpTransportManager() {
        this(DEFAULT_HOST, 20000);
    }

    public ListenerRef createListener(Endpoint endpoint, HttpSpec transportProperties) {
        EndpointServlet listener = new EndpointServlet(endpoint);
        this.httpDeamon.addServletContext(transportProperties.getWebContext(), transportProperties.getUrlPattern(), (Servlet)listener);
        return this.createListenerRef(transportProperties);
    }

    private ListenerRef createListenerRef(HttpSpec transportProperties) {
        assert (transportProperties.getWebContext().startsWith("/"));
        assert (transportProperties.getUrlPattern() != null);
        try {
            String ctx = transportProperties.getWebContext();
            String urlPattern = transportProperties.getUrlPattern();
            URI address = new URI("http://" + this.host + ":" + this.port + ctx + urlPattern);
            return new HttpListenerRef(ctx, urlPattern, address);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Failed to create ListenerRef");
        }
    }

    public void destroyListener(ListenerRef ref) {
        String context = ref.getUUID().substring(0, ref.getUUID().lastIndexOf("/"));
        String urlPattern = ref.getUUID().substring(ref.getUUID().lastIndexOf("/"));
        this.httpDeamon.removeServletContext(context, urlPattern);
    }

    public class EndpointServlet
    extends HttpServlet {
        private final Logger log = Logger.getLogger(EndpointServlet.class);
        protected Endpoint endpoint;
        private boolean started;

        public void init(ServletConfig servletConfig) throws ServletException {
            super.init(servletConfig);
        }

        public EndpointServlet(Endpoint endpoint) {
            if (null == endpoint.getName()) {
                throw new IllegalArgumentException("Endpoint objectName is null");
            }
            this.endpoint = endpoint;
        }

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            response.setContentType("text/plain");
            response.setStatus(200);
            response.getWriter().println(this.endpoint.getName());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
            if (!this.started) {
                this.startEndpoint();
            }
            try {
                EndpointAssociation.setEndpoint((Endpoint)this.endpoint);
                RequestHandler requestHandler = this.endpoint.getRequestHandler();
                requestHandler.handleHttpRequest(this.endpoint, req, res, this.getServletContext());
            }
            finally {
                EndpointAssociation.removeEndpoint();
            }
        }

        private void startEndpoint() {
            Deployment dep = this.endpoint.getService().getDeployment();
            if ((dep.getType() == Deployment.DeploymentType.JAXRPC_JSE || dep.getType() == Deployment.DeploymentType.JAXWS_JSE) && this.endpoint.getState() == Endpoint.EndpointState.CREATED) {
                this.endpoint.getLifecycleHandler().start(this.endpoint);
            }
        }
    }
}

