/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.ws.jaxws.jbws2634.webservice;

import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.jws.WebService;
import javax.xml.ws.WebServiceException;

import org.jboss.test.ws.jaxws.jbws2634.shared.BeanIface;

/**
 * POJO bean published as WebService injecting other EJB3 bean
 *
 * @author <a href="mailto:richard.opalka@jboss.org">Richard Opalka</a>
 */
@WebService
(
   serviceName = "EndpointService", 
   targetNamespace = "http://jbossws.org/JBWS2634", 
   endpointInterface="org.jboss.test.ws.jaxws.jbws2634.webservice.POJOIface"
)
public class POJOBean implements POJOIface
{

   private boolean correctState;
   @EJB
   private BeanIface testBean2;

   private BeanIface testBean1;
   
   @EJB(name = "jaxws-jbws2634/BeanImpl/local-org.jboss.test.ws.jaxws.jbws2634.shared.BeanIface")
   private void setBean(BeanIface bean)
   {
      this.testBean1 = bean;
   }

   public String getMessage()
   {
      if (this.correctState)
      {
         return this.testBean2.printString();
      }

      throw new WebServiceException("@EJB reference injection failed!");
   }
   
   @PostConstruct
   private void init()
   {
      if (this.testBean1 == null)
         return;
      if (!"Injected hello message".equals(testBean1.printString())) 
         return;
      if (this.testBean2 == null)
         return;
      if (!"Injected hello message".equals(testBean2.printString())) 
         return;
      
      this.correctState = true;
   }
   
}
