/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2013, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.ws.jaxws.operationDispatch;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URL;

import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Service;
import javax.xml.ws.Service.Mode;
import javax.xml.ws.soap.SOAPBinding;

import junit.framework.Test;

import org.jboss.wsf.test.JBossWSTest;
import org.jboss.wsf.test.JBossWSTestSetup;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/**
 * Verifies proper operation dispatching based on SOAPAction header
 * 
 * @author alessio.soldano@jboss.com
 */
public class SOAPActionDispatchTestCase extends JBossWSTest
{
   public static Test suite()
   {
      return new JBossWSTestSetup(SOAPActionDispatchTestCase.class, "jaxws-operationDispatch.war");
   }
   
   private final String msgString =
         "<soap:Envelope xmlns:soap='http://schemas.xmlsoap.org/soap/envelope/'>" +
         "  <soap:Body>" +
         "  </soap:Body>" +
         "</soap:Envelope>";

   public void testJAXWSServiceInvocation() throws Exception
   {
      URL wsdlURL = new URL("http://" + getServerHost() + ":8080/jaxws-operationDispatch/SampleWS?wsdl");
      QName serviceName = new QName("http://operationDispatch.jaxws.ws.test.jboss.org/", "SampleWSService");
      Service service = Service.create(wsdlURL, serviceName);

      SampleWSSEI port = service.getPort(SampleWSSEI.class);
      assertEquals("foo", port.foo());      
      assertEquals("bar", port.bar());
   }

   public void testJAXWSDispatchInvocation() throws Exception
   {
      if (isIntegrationCXF()) {
         System.out.println("[FIXME] SOAPAction not set using JAXWS Dispatch");
         return;
      }
      URL url = new URL("http://" + getServerHost() + ":8080/jaxws-operationDispatch/SampleWS");
      QName serviceName = new QName("http://operationDispatch.jaxws.ws.test.jboss.org/", "SampleWSService");
      QName portName = new QName("http://operationDispatch.jaxws.ws.test.jboss.org/", "SampleWSPort");
      
      Service service = Service.create(serviceName);
      service.addPort(portName, SOAPBinding.SOAP11HTTP_BINDING, url.toExternalForm());
      
      Dispatch<SOAPMessage> dispatch = service.createDispatch(portName, SOAPMessage.class, Mode.MESSAGE);
      
      sendMessage(dispatch, "opFoo", "fooResponse");
      sendMessage(dispatch, "opBar", "barResponse");
      
   }
   
   private void sendMessage(final Dispatch<SOAPMessage> dispatch, final String soapAction, final String responseElementName) throws SOAPException, IOException {
      SOAPMessage reqMsg = getRequestMessage();
      reqMsg.getMimeHeaders().addHeader("SOAPAction", soapAction);
      SOAPMessage resMsg = dispatch.invoke(reqMsg);
      SOAPEnvelope resEnv = resMsg.getSOAPPart().getEnvelope();
      
      SOAPHeader soapHeader = resEnv.getHeader();
      if (soapHeader != null)
         soapHeader.detachNode();
      Element body = resEnv.getBody();
      Node child = body.getFirstChild();
      assertEquals(responseElementName, child.getLocalName());
   }
   
   private SOAPMessage getRequestMessage() throws SOAPException, IOException
   {
      MessageFactory msgFactory = MessageFactory.newInstance();
      SOAPMessage reqMsg = msgFactory.createMessage(null, new ByteArrayInputStream(msgString.getBytes()));
      return reqMsg;
   }

}
