/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2010, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.ws.jaxws.benchmark.test.datatypes.wrapped.ejb3;

import java.util.Date;
import java.util.GregorianCalendar;

import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;

import org.jboss.test.ws.jaxws.benchmark.BenchmarkTest;
import org.jboss.test.ws.jaxws.benchmark.test.datatypes.DataTypesEJB3WrappedDocTest;
import org.jboss.test.ws.jaxws.benchmark.test.datatypes.EndpointWrappedDoc;

/**
 * @author pmacik@redhat.com
 * @since 09-Mar-2010
 */
public class ValuesToStringDocTest extends DataTypesEJB3WrappedDocTest implements BenchmarkTest
{
   private static final String stringValue = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<Order orderId=\"1\" orderDate=\"Wed Nov 15 13:45:28 EST 2006\"\n statusCode=\"9\" netAmount=\"59.97\" totalAmount=\"64.92\" tax=\"4.95\">\n  <Customer userName=\"user1\" firstName=\"Harry\" lastName=\"Fletcher\"\n        state=\"SD\" />\n   <OrderLines>\n      <OrderLine position=\"1\" quantity=\"1\">\n         <Product productId=\"364\" title=\"The 40-Year-Old Virgin \"\n              price=\"29.98\" />\n        </OrderLine>\n      <OrderLine position=\"2\" quantity=\"1\">\n         <Product productId=\"299\" title=\"Pulp Fiction\" price=\"29.99\" />\n      </OrderLine>\n      <OrderLine position=\"3\" quantity=\"1\">\n         <Product productId=\"364\" title=\"The 40-Year-Old Virgin \"\n              price=\"29.98\" />\n        </OrderLine>\n      <OrderLine position=\"4\" quantity=\"1\">\n         <Product productId=\"299\" title=\"Pulp Fiction\" price=\"29.99\" />\n      </OrderLine>\n      <OrderLine position=\"5\" quantity=\"1\">\n         <Product productId=\"364\" title=\"The 40-Year-Old Virgin \"\n              price=\"29.98\" />\n        </OrderLine>\n      <OrderLine position=\"6\" quantity=\"1\">\n         <Product productId=\"299\" title=\"Pulp Fiction\" price=\"29.99\" />\n      </OrderLine>\n      <OrderLine position=\"7\" quantity=\"1\">\n         <Product productId=\"364\" title=\"The 40-Year-Old Virgin \"\n              price=\"29.98\" />\n        </OrderLine>\n      <OrderLine position=\"8\" quantity=\"1\">\n         <Product productId=\"299\" title=\"Pulp Fiction\" price=\"29.99\" />\n      </OrderLine>\n      <OrderLine position=\"9\" quantity=\"1\">\n         <Product productId=\"364\" title=\"The 40-Year-Old Virgin \"\n              price=\"29.98\" />\n        </OrderLine>\n      <OrderLine position=\"10\" quantity=\"1\">\n            <Product productId=\"299\" title=\"Pulp Fiction\" price=\"29.99\" />\n      </OrderLine>\n      <OrderLine position=\"11\" quantity=\"1\">\n            <Product productId=\"364\" title=\"The 40-Year-Old Virgin \"\n              price=\"29.98\" />\n        </OrderLine>\n      <OrderLine position=\"12\" quantity=\"1\">\n            <Product productId=\"299\" title=\"Pulp Fiction\" price=\"29.99\" />\n      </OrderLine>\n      <OrderLine position=\"13\" quantity=\"1\">\n            <Product productId=\"364\" title=\"The 40-Year-Old Virgin \"\n              price=\"29.98\" />\n        </OrderLine>\n      <OrderLine position=\"14\" quantity=\"1\">\n            <Product productId=\"299\" title=\"Pulp Fiction\" price=\"29.99\" />\n      </OrderLine>\n      <OrderLine position=\"15\" quantity=\"1\">\n            <Product productId=\"364\" title=\"The 40-Year-Old Virgin \"\n              price=\"29.98\" />\n      <Memo>\n            abcdefghijklmnopqrstuvwxyz0123456789!@#$%^°*()_+-=[]{}:\",.?/`~Pada,pada_jahoda,kterou_sěščřžýáíégggaabcdefghijklmnopqrstuvwxyz0123456789!@#$%^°*()_+-=[]{}:\",.?/`~Pahoda,kterou_sni_pan_Lahodaabcdefghijklmnopqrstuvwxyz0123456789!@#$%^°*()_+-=[]{}:\",.?/`~Pada,pada_jahoda,kterou_sni_pan_Lahoda\n     </Memo>\n   </OrderLines>\n</Order>\n";

   private static final byte byteValue = (byte) 1;

   private static final byte[] byteArrayValue = "!@#$%^°*()_+-=[]{}:\",.?/`~Pada,pada_jahoda,kterou_sěščřžýáíégggaabcdefghijklmnopqrstuvwxyz0123456789"
         .getBytes();

   private static final short shortValue = (short) 3;

   private static final int intValue = 4;

   private static final long longValue = 5L;

   private static final float floatValue = 6.7f;

   private static final double doubleValue = 8.9;

   private static final QName qNameValue = new QName("eleven");

   private static final Date dateValue = new Date();

   private static final XMLGregorianCalendar calendarValue;

   private static final String exp;

   static
   {
      DatatypeFactory dtFactory = null;
      GregorianCalendar calendar = new GregorianCalendar();;
      try
      {
         dtFactory = DatatypeFactory.newInstance();
      }
      catch (DatatypeConfigurationException e)
      {

         e.printStackTrace();
      }
      calendarValue = dtFactory.newXMLGregorianCalendar(calendar);

      StringBuffer sb = new StringBuffer();
      sb.append("[byteValue=" + byteValue);
      sb.append(" byteArrayValue=" + new String(byteArrayValue));
      sb.append(" shortValue=" + shortValue);
      sb.append(" intValue=" + intValue);
      sb.append(" longValue=" + longValue);
      sb.append(" floatValue=" + floatValue);
      sb.append(" doubleValue=" + doubleValue);
      sb.append(" stringValue=" + stringValue);
      sb.append(" qNameValue=" + qNameValue);
      sb.append(" dateValue=" + dateValue);
      sb.append(" calendarValue=" + calendarValue);
      sb.append("]");

      exp = sb.toString();
   }

   public void performIteration(Object port) throws Exception
   {

      String ret = ((EndpointWrappedDoc) port).valuesToString(byteValue, byteArrayValue, shortValue, intValue,
            longValue, floatValue, doubleValue, stringValue, qNameValue, dateValue, calendarValue);
      if (!exp.equals(ret))
      {
         throw new Exception("Unexpected result: " + ret + "\nExpected:" + exp);
      }
   }
}
