/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2010, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.ws.jaxws.jbws3031;

import javax.jws.HandlerChain;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.ws.Action;
import javax.xml.ws.FaultAction;
import javax.xml.ws.RequestWrapper;
import javax.xml.ws.ResponseWrapper;

/**
 * This class was generated by the JAX-WS RI.
 * JAX-WS RI 2.2-12/14/2009 02:16 PM(ramkris)-
 * Generated source version: 2.2
 * 
 */
@WebService(name = "AddNumbersPortType", targetNamespace = "http://example.com/")
@HandlerChain(file = "AddNumbersPortType_handler.xml")
@XmlSeeAlso(
{ObjectFactory.class})
public interface AddNumbersPortType
{

   /**
    * 
    * @param number2
    * @param number1
    * @return
    *     returns int
    * @throws AddNumbersFault_Exception
    * @throws TooBigNumbersFault_Exception
    */
   @WebMethod
   @WebResult(targetNamespace = "http://example.com/")
   @RequestWrapper(localName = "addNumbers", targetNamespace = "http://example.com/", className = "org.jboss.test.ws.jaxws.jbws3031.AddNumbers")
   @ResponseWrapper(localName = "addNumbersResponse", targetNamespace = "http://example.com/", className = "org.jboss.test.ws.jaxws.jbws3031.AddNumbersResponse")
   public int addNumbers(@WebParam(name = "number1", targetNamespace = "http://example.com/") int number1,
         @WebParam(name = "number2", targetNamespace = "http://example.com/") int number2)
         throws AddNumbersFault_Exception, TooBigNumbersFault_Exception;

   /**
    * 
    * @param number2
    * @param number1
    * @return
    *     returns int
    * @throws AddNumbers2Fault
    * @throws TooBigNumbers2Fault
    */
   @WebMethod
   @WebResult(targetNamespace = "http://example.com/")
   @RequestWrapper(localName = "addNumbers2", targetNamespace = "http://example.com/", className = "org.jboss.test.ws.jaxws.jbws3031.AddNumbers")
   @ResponseWrapper(localName = "addNumbersResponse2", targetNamespace = "http://example.com/", className = "org.jboss.test.ws.jaxws.jbws3031.AddNumbersResponse")
   @Action(fault =
   {@FaultAction(className = AddNumbers2Fault.class, value = "add2fault"),
         @FaultAction(className = TooBigNumbers2Fault.class, value = "toobig2fault")})
   public int addNumbers2(@WebParam(name = "number1", targetNamespace = "http://example.com/") int number1,
         @WebParam(name = "number2", targetNamespace = "http://example.com/") int number2) throws AddNumbers2Fault,
         TooBigNumbers2Fault;

   /**
    * 
    * @param number2
    * @param number1
    * @return
    *     returns int
    * @throws AddNumbers3Fault
    * @throws TooBigNumbers3Fault
    */
   @WebMethod
   @WebResult(targetNamespace = "http://example.com/")
   @RequestWrapper(localName = "addNumbers3", targetNamespace = "http://example.com/", className = "org.jboss.test.ws.jaxws.jbws3031.AddNumbers")
   @ResponseWrapper(localName = "addNumbersResponse3", targetNamespace = "http://example.com/", className = "org.jboss.test.ws.jaxws.jbws3031.AddNumbersResponse")
   @Action(fault =
   {@FaultAction(className = AddNumbers3Fault.class, value = "add3fault")})
   public int addNumbers3(@WebParam(name = "number1", targetNamespace = "http://example.com/") int number1,
         @WebParam(name = "number2", targetNamespace = "http://example.com/") int number2) throws AddNumbers3Fault,
         TooBigNumbers3Fault;

   /**
    * 
    * @param number2
    * @param number1
    * @return
    *     returns int
    * @throws TooBigNumbers4Fault
    * @throws AddNumbers4Fault
    */
   @WebMethod
   @WebResult(targetNamespace = "http://example.com/")
   @RequestWrapper(localName = "addNumbers4", targetNamespace = "http://example.com/", className = "org.jboss.test.ws.jaxws.jbws3031.AddNumbers")
   @ResponseWrapper(localName = "addNumbersResponse4", targetNamespace = "http://example.com/", className = "org.jboss.test.ws.jaxws.jbws3031.AddNumbersResponse")
   @Action(fault =
   {@FaultAction(className = TooBigNumbers4Fault.class, value = "toobig4fault")})
   public int addNumbers4(@WebParam(name = "number1", targetNamespace = "http://example.com/") int number1,
         @WebParam(name = "number2", targetNamespace = "http://example.com/") int number2) throws AddNumbers4Fault,
         TooBigNumbers4Fault;

   /**
    * 
    * @param number2
    * @param number1
    * @return
    *     returns int
    * @throws AddNumbers5Fault
    */
   @WebMethod
   @WebResult(targetNamespace = "http://example.com/")
   @RequestWrapper(localName = "addNumbers5", targetNamespace = "http://example.com/", className = "org.jboss.test.ws.jaxws.jbws3031.AddNumbers")
   @ResponseWrapper(localName = "addNumbersResponse5", targetNamespace = "http://example.com/", className = "org.jboss.test.ws.jaxws.jbws3031.AddNumbersResponse")
   @Action(input = "ExplicitInput5", output = "ExplicitOutput5", fault =
   {@FaultAction(className = AddNumbers5Fault.class, value = "fault5")})
   public int addNumbers5(@WebParam(name = "number1", targetNamespace = "http://example.com/") int number1,
         @WebParam(name = "number2", targetNamespace = "http://example.com/") int number2) throws AddNumbers5Fault;

   /**
    * 
    * @param number2
    * @param number1
    * @return
    *     returns int
    * @throws AddNumbers6Fault
    */
   @WebMethod
   @WebResult(targetNamespace = "http://example.com/")
   @RequestWrapper(localName = "addNumbers6", targetNamespace = "http://example.com/", className = "org.jboss.test.ws.jaxws.jbws3031.AddNumbers")
   @ResponseWrapper(localName = "addNumbersResponse6", targetNamespace = "http://example.com/", className = "org.jboss.test.ws.jaxws.jbws3031.AddNumbersResponse")
   @Action(input = "ExplicitInput6")
   public int addNumbers6(@WebParam(name = "number1", targetNamespace = "http://example.com/") int number1,
         @WebParam(name = "number2", targetNamespace = "http://example.com/") int number2) throws AddNumbers6Fault;

}
