/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2010, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.ws.jaxws.jbws2985;

import javax.xml.ws.handler.soap.SOAPMessageContext;

import org.jboss.test.ws.jaxws.common.WsaBaseSOAPHandler;
import org.jboss.test.ws.jaxws.jbws2985.common.TestConstants;

public class ClientSOAPHandler extends WsaBaseSOAPHandler
{
   @Override
   protected void checkInboundAction(final SOAPMessageContext context, final String currentOperation, final String currentAction)
   {
      this.assertAction(currentOperation, currentAction, "addNumbersNoActionResponse", TestConstants.ADD_NUMBERS_OUT_NOACTION);
      this.assertAction(currentOperation, currentAction, "addNumbersEmptyActionResponse", TestConstants.ADD_NUMBERS_OUT_EMPTYACTION);
      this.assertAction(currentOperation, currentAction, "addNumbersResponse", TestConstants.ADD_NUMBERS_OUT_ACTION);
      this.assertAction(currentOperation, currentAction, "addNumbers2Response", TestConstants.ADD_NUMBERS2_OUT_ACTION);
      this.assertAction(currentOperation, currentAction, "addNumbers3Response", TestConstants.ADD_NUMBERS3_OUT_ACTION);
   }

   @Override
   protected void checkFaultActions(final String currentRequestName, final String currentDetailName, final String currentAction)
   {
      this.assertFaultAction(currentRequestName, currentDetailName, currentAction, "addNumbersFault1", "AddNumbersException", TestConstants.ADD_NUMBERS_FAULT1_ADDNUMBERS_ACTION);
      this.assertFaultAction(currentRequestName, currentDetailName, currentAction, "addNumbersFault2", "AddNumbersException", TestConstants.ADD_NUMBERS_FAULT2_ADDNUMBERS_ACTION);
      this.assertFaultAction(currentRequestName, currentDetailName, currentAction, "addNumbersFault2", "TooBigNumbersException", TestConstants.ADD_NUMBERS_FAULT2_TOOBIGNUMBERS_ACTION);
      this.assertFaultAction(currentRequestName, currentDetailName, currentAction, "addNumbersFault3", "AddNumbersException", TestConstants.ADD_NUMBERS_FAULT3_ADDNUMBERS_ACTION);
      this.assertFaultAction(currentRequestName, currentDetailName, currentAction, "addNumbersFault3", "TooBigNumbersException", TestConstants.ADD_NUMBERS_FAULT3_TOOBIGNUMBERS_ACTION);
      this.assertFaultAction(currentRequestName, currentDetailName, currentAction, "addNumbersFault4", "AddNumbersException", TestConstants.ADD_NUMBERS_FAULT4_ADDNUMBERS_ACTION);
      this.assertFaultAction(currentRequestName, currentDetailName, currentAction, "addNumbersFault4", "TooBigNumbersException", TestConstants.ADD_NUMBERS_FAULT4_TOOBIGNUMBERS_ACTION);
      this.assertFaultAction(currentRequestName, currentDetailName, currentAction, "addNumbersFault5", "AddNumbersException", TestConstants.ADD_NUMBERS_FAULT5_ADDNUMBERS_ACTION);
      this.assertFaultAction(currentRequestName, currentDetailName, currentAction, "addNumbersFault5", "TooBigNumbersException", TestConstants.ADD_NUMBERS_FAULT5_TOOBIGNUMBERS_ACTION);
      this.assertFaultAction(currentRequestName, currentDetailName, currentAction, "addNumbersFault6", "AddNumbersException", TestConstants.ADD_NUMBERS_FAULT6_ADDNUMBERS_ACTION);
      this.assertFaultAction(currentRequestName, currentDetailName, currentAction, "addNumbersFault6", "TooBigNumbersException", TestConstants.ADD_NUMBERS_FAULT6_TOOBIGNUMBERS_ACTION);
      this.assertFaultAction(currentRequestName, currentDetailName, currentAction, "addNumbersFault7", "AddNumbersException", TestConstants.ADD_NUMBERS_FAULT7_ADDNUMBERS_ACTION);
      this.assertFaultAction(currentRequestName, currentDetailName, currentAction, "addNumbersFault7", "TooBigNumbersException", TestConstants.ADD_NUMBERS_FAULT7_TOOBIGNUMBERS_ACTION);
   }

   @Override
   protected String whichHandler()
   {
      return "ClientSOAPHandler";
   }
}
