/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2010, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.ws.jaxws.jbws3031;

import javax.xml.ws.handler.soap.SOAPMessageContext;

import org.jboss.test.ws.jaxws.common.WsaBaseSOAPHandler;
import org.jboss.test.ws.jaxws.jbws3031.common.TestConstants;

public class ClientSOAPHandler extends WsaBaseSOAPHandler
{
   @Override
   protected void checkInboundAction(final SOAPMessageContext context, final String currentOperation, final String currentAction)
   {
      this.assertAction(currentOperation, currentAction, "addNumbersResponse2", TestConstants.ADD_NUMBERS2_OUT_ACTION);
      this.assertAction(currentOperation, currentAction, "addNumbersResponse3", TestConstants.ADD_NUMBERS3_OUT_ACTION);
      this.assertAction(currentOperation, currentAction, "addNumbersResponse4", TestConstants.ADD_NUMBERS4_OUT_ACTION);
      this.assertAction(currentOperation, currentAction, "addNumbersResponse5", TestConstants.ADD_NUMBERS5_OUT_ACTION);
      this.assertAction(currentOperation, currentAction, "addNumbersReeponse6", TestConstants.ADD_NUMBERS6_OUT_ACTION);
   }

   @Override
   protected void checkFaultActions(final String currentRequestName, final String currentDetailName, final String currentAction)
   {
      this.assertFaultAction(currentRequestName, currentDetailName, currentAction, "addNumbers", "AddNumbersFault", TestConstants.ADD_NUMBERS_ADDNUMBERS_ACTION);
      this.assertFaultAction(currentRequestName, currentDetailName, currentAction, "addNumbers", "TooBigNumbersFault", TestConstants.ADD_NUMBERS_TOOBIGNUMBERS_ACTION);
      this.assertFaultAction(currentRequestName, currentDetailName, currentAction, "addNumbers2", "AddNumbers2Fault", TestConstants.ADD_NUMBERS2_ADDNUMBERS_ACTION);
      this.assertFaultAction(currentRequestName, currentDetailName, currentAction, "addNumbers2", "TooBigNumbers2Fault", TestConstants.ADD_NUMBERS2_TOOBIGNUMBERS_ACTION);
      this.assertFaultAction(currentRequestName, currentDetailName, currentAction, "addNumbers3", "AddNumbers3Fault", TestConstants.ADD_NUMBERS3_ADDNUMBERS_ACTION);
      this.assertFaultAction(currentRequestName, currentDetailName, currentAction, "addNumbers3", "TooBigNumbers3Fault", TestConstants.ADD_NUMBERS3_TOOBIGNUMBERS_ACTION);
      this.assertFaultAction(currentRequestName, currentDetailName, currentAction, "addNumbers4", "AddNumbers4Fault", TestConstants.ADD_NUMBERS4_ADDNUMBERS_ACTION);
      this.assertFaultAction(currentRequestName, currentDetailName, currentAction, "addNumbers4", "TooBigNumbers4Fault", TestConstants.ADD_NUMBERS4_TOOBIGNUMBERS_ACTION);
      this.assertFaultAction(currentRequestName, currentDetailName, currentAction, "addNumbers5", "AdNumbers5Fault", TestConstants.ADD_NUMBERS5_ADDNUMBERS_ACTION);
      this.assertFaultAction(currentRequestName, currentDetailName, currentAction, "addNumbers6", "AddNumbers6Fault", TestConstants.ADD_NUMBERS6_ADDNUMBERS_ACTION);
   }

   protected String whichHandler()
   {
      return "ClientSOAPHandler";
   }
}
