/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2010, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.ws.jaxws.jbws3031.service;

import javax.jws.WebService;

@WebService(portName = "AddNumbersPort", serviceName = "AddNumbersService", targetNamespace = "http://example.com/", wsdlLocation = "WEB-INF/wsdl/WSAW2JDLActionTest.wsdl", endpointInterface = "org.jboss.test.ws.jaxws.jbws3031.service.AddNumbersPortType")
public class AddNumbersImpl implements AddNumbersPortType
{
   public int addNumbers(int number1, int number2) throws AddNumbersFault_Exception, TooBigNumbersFault_Exception
   {
      if (number1 < 0 || number2 < 0)
      {
         AddNumbersFault faultInfo = createAddNumbersFault(number1, number2);
         throw new AddNumbersFault_Exception(faultInfo.getMessage(), faultInfo);
      }

      if (number1 > 10 || number2 > 10)
      {
         TooBigNumbersFault faultInfo = createTooBigNumbersFaultInfo(number1, number2);
         throw new TooBigNumbersFault_Exception(faultInfo.getMessage(), faultInfo);
      }

      return number1 + number2;
   }

   public int addNumbers2(int number1, int number2) throws AddNumbers2Fault, TooBigNumbers2Fault
   {
      if (number1 < 0 || number2 < 0)
      {
         AddNumbersFault faultInfo = createAddNumbersFault(number1, number2);
         throw new AddNumbers2Fault(faultInfo.getMessage(), faultInfo);
      }

      if (number1 > 10 || number2 > 10)
      {
         TooBigNumbersFault faultInfo = createTooBigNumbersFaultInfo(number1, number2);
         throw new TooBigNumbers2Fault(faultInfo.getMessage(), faultInfo);
      }

      return number1 + number2;
   }

   public int addNumbers3(int number1, int number2) throws AddNumbers3Fault, TooBigNumbers3Fault
   {
      if (number1 < 0 || number2 < 0)
      {
         AddNumbersFault faultInfo = createAddNumbersFault(number1, number2);
         throw new AddNumbers3Fault(faultInfo.getMessage(), faultInfo);
      }

      if (number1 > 10 || number2 > 10)
      {
         TooBigNumbersFault faultInfo = createTooBigNumbersFaultInfo(number1, number2);
         throw new TooBigNumbers3Fault(faultInfo.getMessage(), faultInfo);
      }

      return number1 + number2;
   }

   public int addNumbers4(int number1, int number2) throws AddNumbers4Fault, TooBigNumbers4Fault
   {
      if (number1 < 0 || number2 < 0)
      {
         AddNumbersFault faultInfo = createAddNumbersFault(number1, number2);
         throw new AddNumbers4Fault(faultInfo.getMessage(), faultInfo);
      }

      if (number1 > 10 || number2 > 10)
      {
         TooBigNumbersFault faultInfo = createTooBigNumbersFaultInfo(number1, number2);
         throw new TooBigNumbers4Fault(faultInfo.getMessage(), faultInfo);
      }

      return number1 + number2;
   }

   public int addNumbers5(int number1, int number2) throws AddNumbers5Fault
   {
      if (number1 < 0 || number2 < 0)
      {
         AddNumbersFault faultInfo = createAddNumbersFault(number1, number2);
         throw new AddNumbers5Fault(faultInfo.getMessage(), faultInfo);
      }

      return number1 + number2;
   }

   public int addNumbers6(int number1, int number2) throws AddNumbers6Fault
   {
      if (number1 < 0 || number2 < 0)
      {
         AddNumbersFault faultInfo = createAddNumbersFault(number1, number2);
         throw new AddNumbers6Fault(faultInfo.getMessage(), faultInfo);
      }

      return number1 + number2;
   }

   AddNumbersFault createAddNumbersFault(int number1, int number2)
   {
      ObjectFactory of = new ObjectFactory();
      AddNumbersFault faultInfo = of.createAddNumbersFault();
      faultInfo.setDetail("Negative numbers cant be added!");
      faultInfo.setMessage("Numbers: " + number1 + ", " + number2);

      return faultInfo;
   }

   TooBigNumbersFault createTooBigNumbersFaultInfo(int number1, int number2)
   {
      ObjectFactory of = new ObjectFactory();
      TooBigNumbersFault faultInfo = of.createTooBigNumbersFault();
      faultInfo.setDetail("Too Big numbers cant be added!");
      faultInfo.setMessage("Numbers: " + number1 + ", " + number2);

      return faultInfo;
   }
}
