/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2010, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.ws.jaxws.jbws2991.service;

import javax.jws.WebService;
import javax.jws.WebParam;
import javax.jws.HandlerChain;
import javax.xml.ws.BindingType;
import javax.xml.ws.soap.SOAPBinding;
import javax.xml.ws.Holder;
import javax.xml.ws.soap.Addressing;

@WebService(name = "AddressingFeatureTest4", portName = "AddressingFeatureTest4Port", targetNamespace = "http://addressingfeatureservice.org/wsdl", serviceName = "AddressingFeatureTest4Service")
@BindingType(value = SOAPBinding.SOAP11HTTP_BINDING)
@Addressing(enabled = false)
@HandlerChain(name = "", file = "server-handler.xml")
public class AddressingFeatureTestImpl4
{
   public int addNumbers(
         @WebParam(name = "testName", targetNamespace = "http://addressingfeatureservice.org/xsd", mode = WebParam.Mode.INOUT) Holder<String> testName,
         @WebParam(name = "number1", targetNamespace = "http://addressingfeatureservice.org/xsd") int number1,
         @WebParam(name = "number2", targetNamespace = "http://addressingfeatureservice.org/xsd") int number2)
   {
      if (number1 < 0 || number2 < 0)
      {
         throw new AddressingFeatureException("One of the numbers received was negative:" + number1 + ", " + number2);
      }
      System.out.printf("Adding %s and %s\n", number1, number2);
      return number1 + number2;
   }

}
