/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2010, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.ws.jaxws.jbws3027;

import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;

import javax.xml.soap.SOAPException;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.MessageContext.Scope;
import javax.xml.ws.handler.soap.SOAPMessageContext;

import org.jboss.test.ws.jaxws.common.AddressingHeaderException;
import org.jboss.test.ws.jaxws.common.WsaBaseSOAPHandler;
import org.jboss.test.ws.jaxws.jbws3027.common.TestConstants;

public class ClientSOAPHandler extends WsaBaseSOAPHandler
{
   protected void checkInboundAction(SOAPMessageContext context, String oper, String action)
   {
      if (oper.equals("addNumbers2"))
      {
         if (!action.equals(TestConstants.ADD_NUMBERS2_OUT_ACTION))
         {
            throw new AddressingHeaderException("Expected:" + TestConstants.ADD_NUMBERS2_OUT_ACTION + ", Actual:"
                  + action);
         }
      }
   }

   @SuppressWarnings("unchecked")
   protected void processOutboundMessage(SOAPMessageContext context, String oper, String testName)
   {
      if (testName != null && testName.equals("actionMismatch"))
      {
         Map<String, List<String>> headers = (Map<String, List<String>>) context
               .get(MessageContext.HTTP_REQUEST_HEADERS);
         if (headers == null)
            headers = new Hashtable<String, List<String>>();
         List<String> values = new Vector<String>();
         values.add("ActionNotSupported");
         headers.put("Soapaction", values);
         context.put(MessageContext.HTTP_REQUEST_HEADERS, headers);
         context.setScope(MessageContext.HTTP_REQUEST_HEADERS, Scope.APPLICATION);
      }
   }

   protected String getAction(SOAPMessageContext context) throws SOAPException
   {
      String testName = (String) context.get("test.name");
      if (testName == null)
         return super.getAction(context);
      else if (!testName.equals("missingActionHeader"))
         return super.getAction(context);
      else
         return null;
   }

   protected String whichHandler()
   {
      return "ClientSOAPHandler";
   }
}
