/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2010, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.ws.jaxws.jbws3031.service;

import javax.xml.ws.handler.soap.SOAPMessageContext;

import org.jboss.test.ws.jaxws.common.WsaBaseSOAPHandler;
import org.jboss.test.ws.jaxws.jbws3031.common.TestConstants;

public class ServerSOAPHandler extends WsaBaseSOAPHandler
{
   protected void checkInboundAction(final SOAPMessageContext context, final String currentOperation, final String currentAction)
   {
      this.assertAction(currentOperation, currentAction, "addNumbers", TestConstants.ADD_NUMBERS_IN_ACTION);
      this.assertAction(currentOperation, currentAction, "addNumbers2", TestConstants.ADD_NUMBERS2_IN_ACTION);
      this.assertAction(currentOperation, currentAction, "addNumbers3", TestConstants.ADD_NUMBERS3_IN_ACTION);
      this.assertAction(currentOperation, currentAction, "addNumbers4", TestConstants.ADD_NUMBERS4_IN_ACTION);
      this.assertAction(currentOperation, currentAction, "addNumbers5", TestConstants.ADD_NUMBERS5_IN_ACTION);
      this.assertAction(currentOperation, currentAction, "addNumbers6", TestConstants.ADD_NUMBERS6_IN_ACTION);
   }

   protected String whichHandler()
   {
      return "ServerSOAPHandler";
   }
}
