/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.container.jboss50.transport;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.jboss.deployers.client.spi.DeployerClient;
import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.spi.attachments.MutableAttachments;
import org.jboss.deployers.vfs.spi.client.VFSDeploymentFactory;
import org.jboss.logging.Logger;
import org.jboss.virtual.VFS;
import org.jboss.virtual.VirtualFile;
import org.jboss.wsf.container.jboss50.deployment.tomcat.WebXMLRewriterImpl;
import org.jboss.wsf.spi.deployment.WSFDeploymentException;

public class WebAppDeploymentFactory {
    private static Logger log = Logger.getLogger(WebAppDeploymentFactory.class);
    private DeployerClient mainDeployer;
    private WebXMLRewriterImpl webXMLRewriter;
    private Map<String, Deployment> deploymentMap = new HashMap<String, Deployment>();

    public void setMainDeployer(DeployerClient mainDeployer) {
        this.mainDeployer = mainDeployer;
    }

    public void setWebXMLRewriter(WebXMLRewriterImpl webXMLRewriter) {
        this.webXMLRewriter = webXMLRewriter;
    }

    public void create(org.jboss.wsf.spi.deployment.Deployment dep, URL webAppURL) {
        if (webAppURL == null) {
            throw new IllegalArgumentException("Web meta data URL cannot be null");
        }
        log.debug((Object)("publishServiceEndpoint: " + webAppURL));
        try {
            this.webXMLRewriter.rewriteWebXml(dep);
            dep.setProperty("org.jboss.ws.webapp.url", (Object)webAppURL);
            Deployment deployment = this.createDeploymentContext(webAppURL);
            MutableAttachments attach = (MutableAttachments)deployment.getPredeterminedManagedObjects();
            attach.addAttachment("org.jboss.ws.generated.webapp", (Object)Boolean.TRUE);
            this.mainDeployer.deploy(new Deployment[]{deployment});
            this.deploymentMap.put(webAppURL.toExternalForm(), deployment);
        }
        catch (Exception ex) {
            WSFDeploymentException.rethrow((Throwable)ex);
        }
    }

    public void destroy(org.jboss.wsf.spi.deployment.Deployment dep) {
        URL warURL = (URL)dep.getProperty("org.jboss.ws.webapp.url");
        if (warURL == null) {
            log.error((Object)"Cannot obtain generated webapp URL");
            return;
        }
        log.debug((Object)("destroyServiceEndpoint: " + warURL));
        try {
            Deployment deployment = this.deploymentMap.get(warURL.toExternalForm());
            if (deployment != null) {
                this.mainDeployer.undeploy(new Deployment[]{deployment});
                this.deploymentMap.remove(warURL.toExternalForm());
            }
        }
        catch (Exception ex) {
            WSFDeploymentException.rethrow((Throwable)ex);
        }
    }

    private Deployment createDeploymentContext(URL warURL) throws Exception {
        VirtualFile file = VFS.getRoot((URL)warURL);
        return VFSDeploymentFactory.getInstance().createVFSDeployment(file);
    }
}

