/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.container.jboss50.deployment.metadata;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.jws.WebService;
import javax.xml.ws.WebServiceProvider;
import org.jboss.metadata.javaee.spec.EnvironmentEntriesMetaData;
import org.jboss.metadata.javaee.spec.EnvironmentEntryMetaData;
import org.jboss.metadata.javaee.spec.ResourceInjectionTargetMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.DeploymentAspect;
import org.jboss.wsf.spi.deployment.integration.WebServiceDeclaration;
import org.jboss.wsf.spi.metadata.injection.InjectionMetaData;
import org.jboss.wsf.spi.metadata.injection.InjectionsMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InjectionMetaDataDeploymentAspect
extends DeploymentAspect {
    public void create(Deployment dep) {
        super.create(dep);
        JBossWebMetaData webMD = (JBossWebMetaData)dep.getAttachment(JBossWebMetaData.class);
        if (webMD == null) {
            throw new IllegalStateException("JBossWebMetaData not found");
        }
        LinkedList<InjectionMetaData> injectionMD = new LinkedList<InjectionMetaData>();
        Deployment.DeploymentType deploymentType = dep.getType();
        if (deploymentType == Deployment.DeploymentType.JAXWS_JSE) {
            injectionMD.addAll(this.buildInjectionMetaData(webMD.getEnvironmentEntries()));
        } else if (deploymentType == Deployment.DeploymentType.JAXWS_EJB3) {
            this.log.warn((Object)"Both @Resource annotated methods/fields and descriptor specified injections don't work in handlers associated with EJB3 endpoints");
        }
        dep.getService().addAttachment(InjectionsMetaData.class, (Object)new InjectionsMetaData(injectionMD));
    }

    public void destroy(Deployment dep) {
        dep.getService().removeAttachment(InjectionMetaData.class);
        super.destroy(dep);
    }

    private List<InjectionMetaData> buildInjectionMetaData(EnvironmentEntriesMetaData envEntries) {
        if (envEntries == null || envEntries.size() == 0) {
            return Collections.emptyList();
        }
        EnvironmentEntryMetaData eeMD2 = null;
        LinkedList<InjectionMetaData> retVal = new LinkedList<InjectionMetaData>();
        String envEntryName = null;
        String envEntryValue = null;
        String targetClass = null;
        String targetName = null;
        String valueClass = null;
        for (EnvironmentEntryMetaData eeMD2 : envEntries) {
            envEntryName = eeMD2.getEnvEntryName();
            envEntryValue = eeMD2.getValue();
            valueClass = eeMD2.getType();
            Set injectionTargets = eeMD2.getInjectionTargets();
            if (injectionTargets == null || injectionTargets.size() <= 0) continue;
            for (ResourceInjectionTargetMetaData ritMD : injectionTargets) {
                targetClass = ritMD.getInjectionTargetClass();
                targetName = ritMD.getInjectionTargetName();
                InjectionMetaData injectionMD = new InjectionMetaData(targetClass, targetName, valueClass, envEntryName, envEntryValue != null);
                retVal.add(injectionMD);
                this.log.debug((Object)injectionMD);
            }
        }
        return retVal;
    }

    private boolean isWebServiceBean(WebServiceDeclaration container) {
        boolean isWebService = container.getAnnotation(WebService.class) != null;
        boolean isWebServiceProvider = container.getAnnotation(WebServiceProvider.class) != null;
        return isWebService || isWebServiceProvider;
    }
}

