/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservices.integration.security;

import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import javax.security.auth.Subject;
import org.jboss.security.SecurityAssociation;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.wsf.spi.invocation.SecurityAdaptor;

final class SecurityAdapterImpl
implements SecurityAdaptor {
    SecurityAdapterImpl() {
    }

    public Principal getPrincipal() {
        return SecurityAssociation.getPrincipal();
    }

    public void setPrincipal(Principal principal) {
        SecurityAssociation.setPrincipal((Principal)principal);
    }

    public Object getCredential() {
        return SecurityAssociation.getCredential();
    }

    public void setCredential(Object credential) {
        SecurityAssociation.setCredential((Object)credential);
    }

    public void pushSubjectContext(final Subject subject, final Principal principal, final Object credential) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                SecurityContext securityContext = SecurityContextAssociation.getSecurityContext();
                if (securityContext == null) {
                    throw new IllegalStateException("Security Context is null");
                }
                securityContext.getUtil().createSubjectInfo(principal, credential, subject);
                return null;
            }
        });
    }
}

