/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservices.integration.tomcat;

import javax.annotation.security.RolesAllowed;
import org.jboss.ejb3.annotation.SecurityDomain;
import org.jboss.metadata.javaee.spec.SecurityRoleMetaData;
import org.jboss.metadata.javaee.spec.SecurityRolesMetaData;
import org.jboss.metadata.javaee.support.MappableMetaData;
import org.jboss.webservices.integration.tomcat.AbstractSecurityMetaDataAccessorEJB;
import org.jboss.wsf.common.integration.WSHelper;
import org.jboss.wsf.spi.annotation.WebContext;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.integration.WebServiceDeclaration;
import org.jboss.wsf.spi.deployment.integration.WebServiceDeployment;

final class SecurityMetaDataAccessorEJB3
extends AbstractSecurityMetaDataAccessorEJB {
    SecurityMetaDataAccessorEJB3() {
    }

    @Override
    public String getSecurityDomain(Deployment dep) {
        WebServiceDeployment wsDeployment = (WebServiceDeployment)WSHelper.getRequiredAttachment((Deployment)dep, WebServiceDeployment.class);
        String securityDomain = null;
        for (WebServiceDeclaration ejbContainer : wsDeployment.getServiceEndpoints()) {
            SecurityDomain nextSecurityDomain = (SecurityDomain)ejbContainer.getAnnotation(SecurityDomain.class);
            securityDomain = this.getDomain(securityDomain, nextSecurityDomain);
        }
        return super.appendJaasPrefix(securityDomain);
    }

    @Override
    public SecurityRolesMetaData getSecurityRoles(Deployment dep) {
        WebServiceDeployment wsDeployment = (WebServiceDeployment)WSHelper.getRequiredAttachment((Deployment)dep, WebServiceDeployment.class);
        SecurityRolesMetaData securityRolesMD = new SecurityRolesMetaData();
        for (WebServiceDeclaration ejbContainer : wsDeployment.getServiceEndpoints()) {
            RolesAllowed allowedRoles = (RolesAllowed)ejbContainer.getAnnotation(RolesAllowed.class);
            boolean hasAllowedRoles = allowedRoles != null;
            if (!hasAllowedRoles) continue;
            for (String roleName : allowedRoles.value()) {
                SecurityRoleMetaData securityRoleMD = new SecurityRoleMetaData();
                securityRoleMD.setRoleName(roleName);
                securityRolesMD.add((MappableMetaData)securityRoleMD);
            }
        }
        return securityRolesMD;
    }

    @Override
    public String getAuthMethod(Endpoint endpoint) {
        WebContext webContext = this.getWebContextAnnotation(endpoint);
        boolean hasAuthMethod = webContext != null && webContext.authMethod().length() > 0;
        return hasAuthMethod ? webContext.authMethod() : super.getAuthMethod(endpoint);
    }

    @Override
    public boolean isSecureWsdlAccess(Endpoint endpoint) {
        WebContext webContext = this.getWebContextAnnotation(endpoint);
        boolean hasSecureWsdlAccess = webContext != null && webContext.secureWSDLAccess();
        return hasSecureWsdlAccess ? true : super.isSecureWsdlAccess(endpoint);
    }

    @Override
    public String getTransportGuarantee(Endpoint endpoint) {
        WebContext webContext = this.getWebContextAnnotation(endpoint);
        boolean hasTransportGuarantee = webContext != null && webContext.transportGuarantee().length() > 0;
        return hasTransportGuarantee ? webContext.transportGuarantee() : super.getTransportGuarantee(endpoint);
    }

    private WebContext getWebContextAnnotation(Endpoint endpoint) {
        return endpoint.getTargetBeanClass().getAnnotation(WebContext.class);
    }

    private String getDomain(String oldSecurityDomain, SecurityDomain nextSecurityDomain) {
        if (nextSecurityDomain == null) {
            return oldSecurityDomain;
        }
        if (oldSecurityDomain == null) {
            return nextSecurityDomain.value();
        }
        this.ensureSameDomains(oldSecurityDomain, nextSecurityDomain.value());
        return oldSecurityDomain;
    }

    private void ensureSameDomains(String oldSecurityDomain, String newSecurityDomain) {
        boolean domainsDiffer;
        boolean bl = domainsDiffer = !oldSecurityDomain.equals(newSecurityDomain);
        if (domainsDiffer) {
            String errorMessage = "Multiple security domains not supported. ";
            String firstDomain = "First domain: '" + oldSecurityDomain + "' ";
            String secondDomain = "second domain: '" + newSecurityDomain + "'";
            throw new IllegalStateException("Multiple security domains not supported. " + firstDomain + secondDomain);
        }
    }
}

