/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.container.jboss60.deployer;

import javax.jws.WebService;
import javax.xml.ws.WebServiceProvider;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.metadata.serviceref.VirtualFileAdaptor;
import org.jboss.wsf.container.jboss60.deployer.AbstractDeployerHookEJB;
import org.jboss.wsf.spi.deployment.ArchiveDeployment;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.Service;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
import org.jboss.wsf.spi.deployment.integration.WebServiceDeclaration;
import org.jboss.wsf.spi.deployment.integration.WebServiceDeployment;

public class JAXWSDeployerHookEJB3
extends AbstractDeployerHookEJB {
    public Deployment.DeploymentType getDeploymentType() {
        return Deployment.DeploymentType.JAXWS_EJB3;
    }

    public Deployment createDeployment(DeploymentUnit unit) {
        ArchiveDeployment dep = this.newDeployment(unit);
        dep.setRootFile((UnifiedVirtualFile)new VirtualFileAdaptor(((VFSDeploymentUnit)unit).getRoot()));
        dep.setRuntimeClassLoader(unit.getClassLoader());
        dep.setType(this.getDeploymentType());
        Service service = dep.getService();
        WebServiceDeployment webServiceDeployment = (WebServiceDeployment)unit.getAttachment(WebServiceDeployment.class);
        if (webServiceDeployment == null) {
            throw new IllegalStateException("Deployment unit does not contain webServiceDeployment");
        }
        dep.addAttachment(WebServiceDeployment.class, (Object)webServiceDeployment);
        for (WebServiceDeclaration container : webServiceDeployment.getServiceEndpoints()) {
            if (!this.isWebServiceBean(container)) continue;
            String ejbName = container.getComponentName();
            String epBean = container.getComponentClassName();
            Endpoint ep = this.newEndpoint(epBean);
            ep.setShortName(ejbName);
            String containName = container.getContainerName();
            if (null == containName) {
                throw new IllegalArgumentException("Target container name not set");
            }
            ep.setProperty("org.jboss.wsf.spi.invocation.ContainerName", (Object)containName);
            service.addEndpoint(ep);
        }
        return dep;
    }

    public boolean isWebServiceDeployment(DeploymentUnit unit) {
        WebServiceDeployment webServiceDeployment = (WebServiceDeployment)unit.getAttachment(WebServiceDeployment.class);
        if (null == webServiceDeployment) {
            return false;
        }
        boolean isWebServiceDeployment = false;
        for (WebServiceDeclaration container : webServiceDeployment.getServiceEndpoints()) {
            if (!this.isWebServiceBean(container)) continue;
            isWebServiceDeployment = true;
            break;
        }
        return isWebServiceDeployment;
    }

    private boolean isWebServiceBean(WebServiceDeclaration container) {
        boolean isWebServiceBean = false;
        boolean isWebService = container.getAnnotation(WebService.class) != null;
        boolean isWebServiceProvider = container.getAnnotation(WebServiceProvider.class) != null;
        isWebServiceBean = isWebService || isWebServiceProvider;
        return isWebServiceBean;
    }
}

