/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.dmr;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.webservices.util.WSServices;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;
import org.jboss.wsf.spi.management.ServerConfig;
import org.jboss.wsf.spi.metadata.config.EndpointConfig;
import org.jboss.wsf.spi.metadata.config.Feature;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;

public class EndpointConfigAdd
extends AbstractAddStepHandler {
    static final EndpointConfigAdd INSTANCE = new EndpointConfigAdd();

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        if (operation.hasDefined("pre-handler-chains")) {
            ModelNode preHandlers = operation.get("pre-handler-chains");
            model.get("pre-handler-chains").set(preHandlers);
        }
        if (operation.hasDefined("post-handler-chains")) {
            ModelNode postHandlers = operation.get("post-handler-chains");
            model.get("post-handler-chains").set(postHandlers);
        }
        if (operation.hasDefined("property")) {
            ModelNode property = operation.get("property");
            model.get("property").set(property);
        }
        if (operation.hasDefined("feature")) {
            ModelNode feature = operation.get("feature");
            model.get("feature").set(feature);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ServiceController configService = context.getServiceRegistry(true).getService(WSServices.CONFIG_SERVICE);
        if (configService != null) {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
            String name = address.getLastElement().getValue();
            ServerConfig config = (ServerConfig)configService.getValue();
            EndpointConfig endpointConfig = new EndpointConfig();
            endpointConfig.setConfigName(name);
            if (model.hasDefined("pre-handler-chains")) {
                ModelNode preHandlers = model.get("pre-handler-chains");
                endpointConfig.setPreHandlerChains(this.buildChainMD(preHandlers));
            }
            if (model.hasDefined("post-handler-chains")) {
                ModelNode postHandlers = model.get("post-handler-chains");
                endpointConfig.setPostHandlerChains(this.buildChainMD(postHandlers));
            }
            if (model.hasDefined("property")) {
                for (String key : model.get("property").keys()) {
                    endpointConfig.setProperty(key, model.get("property").get(key).asString());
                }
            }
            if (model.hasDefined("feature")) {
                for (String key : model.get("feature").keys()) {
                    endpointConfig.setFeature(new Feature(key), true);
                }
            }
            config.addEndpointConfig(endpointConfig);
        }
    }

    private List<UnifiedHandlerChainMetaData> buildChainMD(ModelNode handlerChainsNode) {
        ArrayList<UnifiedHandlerChainMetaData> handlerChains = new ArrayList<UnifiedHandlerChainMetaData>();
        if (handlerChainsNode.getType() == ModelType.LIST) {
            for (ModelNode chainNode : handlerChainsNode.asList()) {
                UnifiedHandlerChainMetaData chainMetaData = new UnifiedHandlerChainMetaData();
                if (chainNode.hasDefined("protocol-bindings")) {
                    chainMetaData.setProtocolBindings(chainNode.get("protocol-bindings").asString());
                }
                if (chainNode.hasDefined("service-name-pattern")) {
                    chainMetaData.setServiceNamePattern(new QName(chainNode.get("service-name-pattern").asString()));
                }
                if (chainNode.hasDefined("port-name-pattern")) {
                    chainMetaData.setPortNamePattern(new QName(chainNode.get("port-name-pattern").asString()));
                }
                if (chainNode.hasDefined("handler")) {
                    for (String key : chainNode.get("handler").keys()) {
                        UnifiedHandlerMetaData handlerMD = new UnifiedHandlerMetaData();
                        handlerMD.setHandlerName(key);
                        handlerMD.setHandlerClass(chainNode.get("handler").get(key).asString());
                        chainMetaData.addHandler(handlerMD);
                    }
                }
                handlerChains.add(chainMetaData);
            }
        }
        return handlerChains;
    }
}

