/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.dmr;

import java.util.Locale;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.webservices.dmr.EndpointConfigAdd;
import org.jboss.as.webservices.dmr.EndpointConfigRemove;
import org.jboss.as.webservices.dmr.Namespace;
import org.jboss.as.webservices.dmr.WSEndpointMetrics;
import org.jboss.as.webservices.dmr.WSSubsystemAdd;
import org.jboss.as.webservices.dmr.WSSubsystemDescribe;
import org.jboss.as.webservices.dmr.WSSubsystemProviders;
import org.jboss.as.webservices.dmr.WebservicesSubsystemParser;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;

public final class WSExtension
implements Extension {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.webservices");
    public static final String SUBSYSTEM_NAME = "webservices";

    public void initialize(ExtensionContext context) {
        log.debugf("Activating WebServices Extension", new Object[0]);
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME);
        subsystem.registerXMLElementWriter((XMLElementWriter)WebservicesSubsystemParser.getInstance());
        ManagementResourceRegistration registration = subsystem.registerSubsystemModel(WSSubsystemProviders.SUBSYSTEM);
        registration.registerOperationHandler("add", (OperationStepHandler)WSSubsystemAdd.INSTANCE, WSSubsystemProviders.SUBSYSTEM_ADD, false);
        registration.registerOperationHandler("describe", (OperationStepHandler)WSSubsystemDescribe.INSTANCE, WSSubsystemProviders.SUBSYSTEM_DESCRIBE, false, OperationEntry.EntryType.PRIVATE);
        ManagementResourceRegistration epConfigs = registration.registerSubModel(PathElement.pathElement((String)"endpoint-config"), WSSubsystemProviders.ENDPOINTCONFIG_DESCRIPTION);
        epConfigs.registerOperationHandler("add", (OperationStepHandler)EndpointConfigAdd.INSTANCE, WSSubsystemProviders.ENDPOINTCONFIG_ADD_DESCRIPTION, false);
        epConfigs.registerOperationHandler("remove", (OperationStepHandler)EndpointConfigRemove.INSTANCE, WSSubsystemProviders.ENDPOINTCONFIG_REMOVE_DESCRIPTION, false);
        ManagementResourceRegistration deployments = subsystem.registerDeploymentModel(new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return new ModelNode();
            }
        });
        ManagementResourceRegistration endpoints = deployments.registerSubModel(PathElement.pathElement((String)"endpoint"), WSSubsystemProviders.ENDPOINT_DESCRIPTION);
        for (String attributeName : WSEndpointMetrics.ATTRIBUTES) {
            endpoints.registerMetric(attributeName, (OperationStepHandler)WSEndpointMetrics.INSTANCE);
        }
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(Namespace.CURRENT.getUriString(), (XMLElementReader)WebservicesSubsystemParser.getInstance());
    }
}

