/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.deployers.deployment;

import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.webservices.deployers.deployment.DeploymentModelBuilder;
import org.jboss.as.webservices.deployers.deployment.DeploymentModelBuilderJAXRPC_EJB21;
import org.jboss.as.webservices.deployers.deployment.DeploymentModelBuilderJAXRPC_JSE;
import org.jboss.as.webservices.deployers.deployment.DeploymentModelBuilderJAXWS_EJB3;
import org.jboss.as.webservices.deployers.deployment.DeploymentModelBuilderJAXWS_JSE;
import org.jboss.as.webservices.util.ASHelper;
import org.jboss.logging.Logger;

public final class WSDeploymentBuilder {
    private static final Logger log = Logger.getLogger(WSDeploymentBuilder.class);
    private static final WSDeploymentBuilder SINGLETON = new WSDeploymentBuilder();
    private static final DeploymentModelBuilder JAXWS_JSE = new DeploymentModelBuilderJAXWS_JSE();
    private static final DeploymentModelBuilder JAXRPC_JSE = new DeploymentModelBuilderJAXRPC_JSE();
    private static final DeploymentModelBuilder JAXWS_EJB = new DeploymentModelBuilderJAXWS_EJB3();
    private static final DeploymentModelBuilder JAXRPC_EJB = new DeploymentModelBuilderJAXRPC_EJB21();

    private WSDeploymentBuilder() {
    }

    public static WSDeploymentBuilder getInstance() {
        return SINGLETON;
    }

    public void build(DeploymentUnit unit) {
        boolean isJaxwsDeployment = false;
        if (ASHelper.isJaxwsJseDeployment(unit)) {
            log.debug((Object)"Detected JAXWS JSE deployment");
            JAXWS_JSE.newDeploymentModel(unit);
            isJaxwsDeployment = true;
        }
        if (ASHelper.isJaxwsEjbDeployment(unit)) {
            log.debug((Object)"Detected JAXWS EJB3 deployment");
            JAXWS_EJB.newDeploymentModel(unit);
            isJaxwsDeployment = true;
        }
        if (!isJaxwsDeployment && ASHelper.isJaxrpcJseDeployment(unit)) {
            log.debug((Object)"Detected JAXRPC JSE deployment");
            JAXRPC_JSE.newDeploymentModel(unit);
        }
        if (!isJaxwsDeployment && ASHelper.isJaxrpcEjbDeployment(unit)) {
            log.debug((Object)"Detected JAXRPC EJB21 deployment");
            JAXRPC_EJB.newDeploymentModel(unit);
        }
    }
}

