/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.invocation;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Collection;
import javax.management.MBeanException;
import javax.xml.ws.soap.SOAPFaultException;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentView;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.webservices.WSMessages;
import org.jboss.as.webservices.metadata.model.EJBEndpoint;
import org.jboss.as.webservices.util.ASHelper;
import org.jboss.invocation.InterceptorContext;
import org.jboss.msc.service.ServiceName;
import org.jboss.ws.common.invocation.AbstractInvocationHandler;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.invocation.Invocation;

abstract class AbstractInvocationHandlerEJB
extends AbstractInvocationHandler {
    private ServiceName ejbComponentViewName;
    private volatile ComponentView ejbComponentView;
    private volatile ManagedReference reference;

    AbstractInvocationHandlerEJB() {
    }

    public void init(Endpoint endpoint) {
        this.ejbComponentViewName = (ServiceName)endpoint.getProperty(EJBEndpoint.EJB_COMPONENT_VIEW_NAME);
        if (this.ejbComponentViewName == null) {
            throw WSMessages.MESSAGES.missingEjbComponentViewName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ComponentView getComponentView() {
        if (this.ejbComponentView == null || this.reference == null) {
            AbstractInvocationHandlerEJB abstractInvocationHandlerEJB = this;
            synchronized (abstractInvocationHandlerEJB) {
                if (this.ejbComponentView == null) {
                    this.ejbComponentView = ASHelper.getMSCService(this.ejbComponentViewName, ComponentView.class);
                    if (this.ejbComponentView == null) {
                        throw WSMessages.MESSAGES.cannotFindEjbView(this.ejbComponentViewName);
                    }
                    try {
                        this.reference = this.ejbComponentView.createInstance();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return this.ejbComponentView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Endpoint endpoint, Invocation wsInvocation) throws Exception {
        try {
            this.onBeforeInvocation(wsInvocation);
            ComponentView componentView = this.getComponentView();
            Method method = this.getEJBMethod(wsInvocation.getJavaMethod(), componentView.getViewMethods());
            InterceptorContext context = new InterceptorContext();
            this.prepareForInvocation(context, wsInvocation);
            context.setMethod(method);
            context.setParameters(wsInvocation.getArgs());
            context.setTarget(this.reference.getInstance());
            context.putPrivateData(Component.class, (Object)componentView.getComponent());
            context.putPrivateData(ComponentView.class, (Object)componentView);
            Object retObj = componentView.invoke(context);
            wsInvocation.setReturnValue(retObj);
        }
        catch (Throwable t) {
            this.log.error((Object)("Method invocation failed with exception: " + t.getMessage()), t);
            this.handleInvocationException(t);
        }
        finally {
            this.onAfterInvocation(wsInvocation);
        }
    }

    protected void handleInvocationException(Throwable t) throws Exception {
        if (t instanceof MBeanException) {
            throw ((MBeanException)t).getTargetException();
        }
        if (t instanceof Exception) {
            SOAPFaultException ex = this.findSoapFaultException(t);
            if (ex != null) {
                throw new InvocationTargetException((Throwable)ex);
            }
            throw (Exception)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new UndeclaredThrowableException(t);
    }

    protected SOAPFaultException findSoapFaultException(Throwable ex) {
        if (ex instanceof SOAPFaultException) {
            return (SOAPFaultException)ex;
        }
        if (ex.getCause() != null) {
            return this.findSoapFaultException(ex.getCause());
        }
        return null;
    }

    private Method getEJBMethod(Method seiMethod, Collection<Method> viewMethods) {
        for (Method viewMethod : viewMethods) {
            if (!this.matches(seiMethod, viewMethod)) continue;
            return viewMethod;
        }
        throw new IllegalStateException();
    }

    private boolean matches(Method seiMethod, Method viewMethod) {
        Class<?>[] targetParams;
        if (!seiMethod.getName().equals(viewMethod.getName())) {
            return false;
        }
        Class<?>[] sourceParams = seiMethod.getParameterTypes();
        if (sourceParams.length != (targetParams = viewMethod.getParameterTypes()).length) {
            return false;
        }
        for (int i = 0; i < sourceParams.length; ++i) {
            if (sourceParams[i].equals(targetParams[i])) continue;
            return false;
        }
        return true;
    }

    protected void prepareForInvocation(InterceptorContext context, Invocation wsInvocation) {
    }
}

