/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.dmr;

import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.webservices.WSMessages;
import org.jboss.as.webservices.dmr.Attributes;
import org.jboss.as.webservices.dmr.PackageUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.wsf.spi.management.ServerConfig;
import org.jboss.wsf.spi.metadata.config.CommonConfig;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;

final class HandlerAdd
extends AbstractAddStepHandler {
    static final HandlerAdd INSTANCE = new HandlerAdd();

    private HandlerAdd() {
    }

    protected void rollbackRuntime(OperationContext context, ModelNode operation, ModelNode model, List<ServiceController<?>> controllers) {
        super.rollbackRuntime(context, operation, model, controllers);
        if (!context.isBooting()) {
            context.revertReloadRequired();
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ServerConfig config = PackageUtils.getServerConfig(context);
        if (config != null) {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
            PathElement confElem = address.getElement(address.size() - 3);
            String configType = confElem.getKey();
            String configName = confElem.getValue();
            String handlerChainType = address.getElement(address.size() - 2).getKey();
            String handlerChainId = address.getElement(address.size() - 2).getValue();
            String handlerName = address.getElement(address.size() - 1).getValue();
            String handlerClass = operation.require("class").asString();
            for (CommonConfig commonConfig : PackageUtils.getConfigs(config, configType)) {
                List handlerChains;
                if (!configName.equals(commonConfig.getConfigName())) continue;
                if ("pre-handler-chain".equals(handlerChainType)) {
                    handlerChains = commonConfig.getPreHandlerChains();
                } else if ("post-handler-chain".equals(handlerChainType)) {
                    handlerChains = commonConfig.getPostHandlerChains();
                } else {
                    throw WSMessages.MESSAGES.wrongHandlerChainType(handlerChainType, "pre-handler-chain", "post-handler-chain");
                }
                UnifiedHandlerChainMetaData handlerChain = HandlerAdd.getChain(handlerChains, handlerChainId);
                if (handlerChain == null) {
                    throw WSMessages.MESSAGES.multipleHandlerChainsWithSameId(handlerChainType, handlerChainId, configName);
                }
                UnifiedHandlerMetaData handler = new UnifiedHandlerMetaData();
                handler.setHandlerName(handlerName);
                handler.setHandlerClass(handlerClass);
                handlerChain.addHandler(handler);
                if (!context.isBooting()) {
                    context.reloadRequired();
                }
                return;
            }
            throw WSMessages.MESSAGES.missingConfig(configName);
        }
    }

    private static UnifiedHandlerChainMetaData getChain(List<UnifiedHandlerChainMetaData> handlerChains, String handlerChainId) {
        if (handlerChains != null) {
            for (UnifiedHandlerChainMetaData handlerChain : handlerChains) {
                if (!handlerChainId.equals(handlerChain.getId())) continue;
                return handlerChain;
            }
        }
        return null;
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        Attributes.CLASS.validateAndSet(operation, model);
    }
}

