/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.test;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.management.MBeanServerConnection;
import javax.naming.NamingException;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.jboss.logging.Logger;
import org.jboss.wsf.test.JBossWSTestHelper;

public class JBossWSTestSetup
extends TestSetup {
    private static Logger log = Logger.getLogger(JBossWSTestSetup.class);
    private static final String JBOSSWS_SEC_DOMAIN = "JBossWS";
    private String[] archives = new String[0];
    private ClassLoader originalClassLoader;
    private Map<String, Map<String, String>> securityDomains = new HashMap<String, Map<String, String>>();
    private boolean defaultSecurityDomainRequirement = false;

    public JBossWSTestSetup(Class<?> testClass, String archiveList) {
        super((Test)new TestSuite(testClass));
        this.getArchiveArray(archiveList);
    }

    public JBossWSTestSetup(Class<?> testClass, String archiveList, boolean requiresDefaultSecurityDomain) {
        this(testClass, archiveList);
        this.setDefaultSecurityDomainRequirement(requiresDefaultSecurityDomain);
    }

    public JBossWSTestSetup(Test test, String archiveList) {
        super(test);
        this.getArchiveArray(archiveList);
    }

    public JBossWSTestSetup(Test test, String archiveList, boolean requiresDefaultSecurityDomain) {
        this(test, archiveList);
        this.setDefaultSecurityDomainRequirement(requiresDefaultSecurityDomain);
    }

    public JBossWSTestSetup(Test test) {
        super(test);
    }

    public File getArchiveFile(String archive) {
        return JBossWSTestHelper.getArchiveFile(archive);
    }

    public URL getArchiveURL(String archive) throws MalformedURLException {
        return JBossWSTestHelper.getArchiveFile(archive).toURI().toURL();
    }

    public File getResourceFile(String resource) {
        return JBossWSTestHelper.getResourceFile(resource);
    }

    public URL getResourceURL(String resource) throws MalformedURLException {
        return JBossWSTestHelper.getResourceFile(resource).toURI().toURL();
    }

    private void getArchiveArray(String archiveList) {
        if (archiveList != null) {
            StringTokenizer st = new StringTokenizer(archiveList, ", ");
            this.archives = new String[st.countTokens()];
            for (int i = 0; i < this.archives.length; ++i) {
                this.archives[i] = st.nextToken();
            }
        }
    }

    protected void setUp() throws Exception {
        ClassLoader parent;
        String integrationTarget = JBossWSTestHelper.getIntegrationTarget();
        log.debug((Object)("Integration target: " + integrationTarget));
        if (!this.securityDomains.isEmpty()) {
            for (String key : this.securityDomains.keySet()) {
                JBossWSTestHelper.addSecurityDomain(key, this.securityDomains.get(key));
            }
        }
        if (this.defaultSecurityDomainRequirement) {
            String usersPropFile = System.getProperty("org.jboss.ws.testsuite.securityDomain.users.propfile");
            String rolesPropFile = System.getProperty("org.jboss.ws.testsuite.securityDomain.roles.propfile");
            HashMap<String, String> authenticationOptions = new HashMap<String, String>();
            if (usersPropFile != null) {
                authenticationOptions.put("usersProperties", usersPropFile);
            }
            if (rolesPropFile != null) {
                authenticationOptions.put("rolesProperties", rolesPropFile);
            }
            authenticationOptions.put("unauthenticatedIdentity", "anonymous");
            JBossWSTestHelper.addSecurityDomain(JBOSSWS_SEC_DOMAIN, authenticationOptions);
        }
        ArrayList<URL> clientJars = new ArrayList<URL>();
        for (int i = 0; i < this.archives.length; ++i) {
            String archive = this.archives[i];
            if (archive.endsWith("-client.jar")) {
                URL archiveURL = this.getArchiveURL(archive);
                clientJars.add(archiveURL);
                if (!archive.contains("jaxrpc") && !archive.endsWith("serviceref-client.jar")) continue;
                JBossWSTestSetup.performDeploy(archive);
                continue;
            }
            JBossWSTestSetup.performDeploy(archive);
        }
        this.originalClassLoader = parent = Thread.currentThread().getContextClassLoader();
        if (!clientJars.isEmpty()) {
            URL[] urls = new URL[clientJars.size()];
            for (int i = 0; i < clientJars.size(); ++i) {
                urls[i] = (URL)clientJars.get(i);
            }
            URLClassLoader cl = new URLClassLoader(urls, parent);
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    private static void performDeploy(String archive) throws Exception {
        try {
            JBossWSTestHelper.deploy(archive);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JBossWSTestHelper.undeploy(archive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tearDown() throws Exception {
        try {
            for (int i = 0; i < this.archives.length; ++i) {
                String archive = this.archives[this.archives.length - i - 1];
                JBossWSTestHelper.undeploy(archive);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(this.originalClassLoader);
            if (!this.securityDomains.isEmpty()) {
                for (String key : this.securityDomains.keySet()) {
                    JBossWSTestHelper.removeSecurityDomain(key);
                }
            }
            if (this.defaultSecurityDomainRequirement) {
                JBossWSTestHelper.removeSecurityDomain(JBOSSWS_SEC_DOMAIN);
            }
        }
    }

    protected ClassLoader getOriginalClassLoader() {
        return this.originalClassLoader;
    }

    public MBeanServerConnection getServer() throws NamingException {
        return JBossWSTestHelper.getServer();
    }

    public void addSecurityDomainRequirement(String securityDomainName, Map<String, String> authenticationOptions) {
        this.securityDomains.put(securityDomainName, authenticationOptions);
    }

    public void setDefaultSecurityDomainRequirement(boolean defaultSecurityDomainRequirement) {
        this.defaultSecurityDomainRequirement = defaultSecurityDomainRequirement;
    }
}

