/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.spi.metadata.injection;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import javax.naming.Context;
import org.jboss.wsf.spi.metadata.injection.InjectionMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InjectionsMetaData {
    private static final Collection<InjectionMetaData> EMPTY_LIST = Collections.emptyList();
    private final Collection<InjectionMetaData> injections;
    private final Context ctx;

    public InjectionsMetaData(Collection<InjectionMetaData> injections, Context ctx) {
        if (injections == null) {
            throw new IllegalArgumentException("injections metadata list cannot be null");
        }
        this.injections = injections;
        this.ctx = ctx;
    }

    public Context getContext() {
        return this.ctx;
    }

    public Collection<InjectionMetaData> getInjectionsMetaData(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("class cannot be null");
        }
        if (this.injections.size() == 0) {
            return EMPTY_LIST;
        }
        LinkedList<InjectionMetaData> retVal = null;
        for (InjectionMetaData injectionMD : this.injections) {
            if (!clazz.getName().equals(injectionMD.getTargetClass()) || !injectionMD.isEnvEntryValueSpecified()) continue;
            if (retVal == null) {
                retVal = new LinkedList<InjectionMetaData>();
            }
            retVal.add(injectionMD);
        }
        return retVal == null ? EMPTY_LIST : retVal;
    }
}

