/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.spi.metadata.injection;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import org.jboss.wsf.spi.metadata.injection.InjectionMetaData;
import org.jboss.wsf.spi.metadata.injection.ReferenceResolver;

public final class InjectionsMetaData {
    private static final Collection<InjectionMetaData> EMPTY_LIST = Collections.emptyList();
    private final Collection<InjectionMetaData> injections;
    private final Map<Class<? extends Annotation>, ReferenceResolver> referenceResolvers;

    public InjectionsMetaData(Collection<InjectionMetaData> injections, Map<Class<? extends Annotation>, ReferenceResolver> resolvers) {
        if (injections == null) {
            throw new IllegalArgumentException("injections metadata list cannot be null");
        }
        if (resolvers == null || resolvers.size() == 0) {
            throw new IllegalArgumentException("reference resolvers list cannot be null or empty collection");
        }
        this.injections = injections;
        this.referenceResolvers = resolvers;
    }

    public Collection<InjectionMetaData> getInjectionsMetaData(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("class cannot be null");
        }
        if (this.injections.size() == 0) {
            return EMPTY_LIST;
        }
        LinkedList<InjectionMetaData> retVal = null;
        for (InjectionMetaData injectionMD : this.injections) {
            if (!clazz.getName().equals(injectionMD.getTargetClass()) || !injectionMD.isEnvEntryValueSpecified()) continue;
            if (retVal == null) {
                retVal = new LinkedList<InjectionMetaData>();
            }
            retVal.add(injectionMD);
        }
        return retVal == null ? EMPTY_LIST : retVal;
    }

    public ReferenceResolver getResolver(Class<? extends Annotation> annotation) {
        ReferenceResolver resolver = this.referenceResolvers.get(annotation);
        if (resolver == null) {
            throw new IllegalArgumentException("No registered reference resolver for: " + annotation);
        }
        return resolver;
    }
}

