/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.spi.metadata.webservices;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainsMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;
import org.jboss.wsf.spi.metadata.webservices.WebserviceDescriptionMetaData;

public class PortComponentMetaData {
    public static final String PARAMETER_WEBSERVICE_ID = "webserviceID";
    private static final Logger log = Logger.getLogger(PortComponentMetaData.class);
    private WebserviceDescriptionMetaData webserviceDescription;
    private String portComponentName;
    private QName wsdlPort;
    private String serviceEndpointInterface;
    private String ejbLink;
    private String servletLink;
    private List<UnifiedHandlerMetaData> handlers = new ArrayList<UnifiedHandlerMetaData>();
    private String contextRoot;
    private Boolean secureWSDLAccess;
    private boolean addressingEnabled;
    private boolean addressingRequired;
    private String addressingResponses = "ALL";
    private boolean mtomEnabled;
    private int mtomThreshold;
    private boolean respectBindingEnabled;
    private QName wsdlService;
    private String protocolBinding;
    private UnifiedHandlerChainsMetaData handlerChains;

    public PortComponentMetaData(WebserviceDescriptionMetaData webserviceDescription) {
        this.webserviceDescription = webserviceDescription;
    }

    public WebserviceDescriptionMetaData getWebserviceDescription() {
        return this.webserviceDescription;
    }

    public String getPortComponentName() {
        return this.portComponentName;
    }

    public void setPortComponentName(String portComponentName) {
        this.portComponentName = portComponentName;
    }

    public QName getWsdlPort() {
        return this.wsdlPort;
    }

    public void setWsdlPort(QName wsdlPort) {
        if (wsdlPort.getNamespaceURI().length() == 0) {
            log.warn((Object)("<wsdl-port> element in webservices.xml not namespace qualified: " + wsdlPort));
        }
        this.wsdlPort = wsdlPort;
    }

    public String getEjbLink() {
        return this.ejbLink;
    }

    public void setEjbLink(String ejbLink) {
        this.ejbLink = ejbLink;
    }

    public String getServletLink() {
        return this.servletLink;
    }

    public void setServletLink(String servletLink) {
        this.servletLink = servletLink;
    }

    public String getServiceEndpointInterface() {
        return this.serviceEndpointInterface;
    }

    public void setServiceEndpointInterface(String serviceEndpointInterface) {
        this.serviceEndpointInterface = serviceEndpointInterface;
    }

    public void addHandler(UnifiedHandlerMetaData handler) {
        this.handlers.add(handler);
    }

    public UnifiedHandlerMetaData[] getHandlers() {
        UnifiedHandlerMetaData[] array = new UnifiedHandlerMetaData[this.handlers.size()];
        this.handlers.toArray(array);
        return array;
    }

    public String getContextRoot() {
        return this.contextRoot;
    }

    public void setContextRoot(String contextRoot) {
        this.contextRoot = contextRoot;
    }

    public Boolean getSecureWSDLAccess() {
        return this.secureWSDLAccess;
    }

    public void setSecureWSDLAccess(Boolean secureWSDLAccess) {
        this.secureWSDLAccess = secureWSDLAccess;
    }

    @Deprecated
    public boolean isEnableMtom() {
        return this.mtomEnabled;
    }

    @Deprecated
    public void setEnableMtom(boolean enableMtom) {
        this.mtomEnabled = enableMtom;
    }

    public void setAddressingEnabled(boolean addressingEnabled) {
        this.addressingEnabled = addressingEnabled;
    }

    public boolean isAddressingEnabled() {
        return this.addressingEnabled;
    }

    public void setAddressingRequired(boolean addressingRequired) {
        this.addressingRequired = addressingRequired;
    }

    public boolean isAddressingRequired() {
        return this.addressingRequired;
    }

    public void setAddressingResponses(String responsesTypes) {
        if (!("ANONYMOUS".equals(responsesTypes) || "NON_ANONYMOUS".equals(responsesTypes) || "ALL".equals(responsesTypes))) {
            throw new IllegalArgumentException("Only ALL, ANONYMOUS or NON_ANONYMOUS strings are allowed");
        }
        this.addressingResponses = responsesTypes;
    }

    public String getAddressingResponses() {
        return this.addressingResponses;
    }

    public void setMtomEnabled(boolean mtomEnabled) {
        this.mtomEnabled = mtomEnabled;
    }

    public boolean isMtomEnabled() {
        return this.mtomEnabled;
    }

    public void setMtomThreshold(int mtomThreshold) {
        this.mtomThreshold = mtomThreshold;
    }

    public int getMtomThreshold() {
        return this.mtomThreshold;
    }

    public void setRespectBindingEnabled(boolean respectBindingEnabled) {
        this.respectBindingEnabled = respectBindingEnabled;
    }

    public boolean isRespectBindingEnabled() {
        return this.respectBindingEnabled;
    }

    public QName getWsdlService() {
        return this.wsdlService;
    }

    public void setWsdlService(QName wsdlService) {
        this.wsdlService = wsdlService;
    }

    public String getProtocolBinding() {
        return this.protocolBinding;
    }

    public void setProtocolBinding(String protocolBinding) {
        this.protocolBinding = protocolBinding;
    }

    public UnifiedHandlerChainsMetaData getHandlerChains() {
        return this.handlerChains;
    }

    public void setHandlerChains(UnifiedHandlerChainsMetaData handlerChains) {
        this.handlerChains = handlerChains;
    }

    public String serialize() {
        StringBuilder builder = new StringBuilder("<port-component>");
        builder.append("<port-component-name>").append(this.portComponentName).append("</port-component-name>");
        builder.append("<wsdl-port xmlns:").append(this.wsdlPort.getPrefix()).append("='").append(this.wsdlPort.getNamespaceURI()).append("'>");
        builder.append(this.wsdlPort.getPrefix()).append(':').append(this.wsdlPort.getLocalPart()).append("</wsdl-port>");
        builder.append("<service-endpoint-interface>").append(this.serviceEndpointInterface).append("</service-endpoint-interface>");
        builder.append("<service-impl-bean>");
        if (this.ejbLink != null) {
            builder.append("<ejb-link>" + this.ejbLink + "</ejb-link>");
        } else {
            builder.append("<servlet-link>" + this.servletLink + "</servlet-link>");
        }
        builder.append("</service-impl-bean>");
        builder.append("</port-component>");
        return builder.toString();
    }
}

