/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.metadata;

import java.util.List;
import org.jboss.as.webservices.WSLogger;
import org.jboss.as.webservices.metadata.PublishLocationAdapterImpl;
import org.jboss.as.webservices.metadata.model.EJBEndpoint;
import org.jboss.ws.common.integration.WSHelper;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.metadata.j2ee.EJBArchiveMetaData;
import org.jboss.wsf.spi.metadata.j2ee.EJBMetaData;
import org.jboss.wsf.spi.metadata.j2ee.EJBSecurityMetaData;
import org.jboss.wsf.spi.metadata.j2ee.PublishLocationAdapter;
import org.jboss.wsf.spi.metadata.j2ee.SLSBMetaData;
import org.jboss.wsf.spi.metadata.webservices.JBossPortComponentMetaData;
import org.jboss.wsf.spi.metadata.webservices.JBossWebserviceDescriptionMetaData;
import org.jboss.wsf.spi.metadata.webservices.JBossWebservicesMetaData;

abstract class AbstractMetaDataBuilderEJB {
    AbstractMetaDataBuilderEJB() {
    }

    final EJBArchiveMetaData create(Deployment dep) {
        WSLogger.ROOT_LOGGER.creatingEjbDeployment(dep.getSimpleName());
        EJBArchiveMetaData.Builder ejbArchiveMDBuilder = new EJBArchiveMetaData.Builder();
        this.buildEnterpriseBeansMetaData(dep, ejbArchiveMDBuilder);
        this.buildWebservicesMetaData(dep, ejbArchiveMDBuilder);
        return ejbArchiveMDBuilder.build();
    }

    protected abstract void buildEnterpriseBeansMetaData(Deployment var1, EJBArchiveMetaData.Builder var2);

    private void buildWebservicesMetaData(Deployment dep, EJBArchiveMetaData.Builder ejbArchiveMDBuilder) {
        JBossWebservicesMetaData webservicesMD = (JBossWebservicesMetaData)WSHelper.getOptionalAttachment((Deployment)dep, JBossWebservicesMetaData.class);
        if (webservicesMD == null) {
            return;
        }
        String contextRoot = webservicesMD.getContextRoot();
        ejbArchiveMDBuilder.setWebServiceContextRoot(contextRoot);
        WSLogger.ROOT_LOGGER.settingContextRoot(contextRoot);
        String configName = webservicesMD.getConfigName();
        ejbArchiveMDBuilder.setConfigName(configName);
        WSLogger.ROOT_LOGGER.settingConfigName(configName);
        String configFile = webservicesMD.getConfigFile();
        ejbArchiveMDBuilder.setConfigFile(configFile);
        WSLogger.ROOT_LOGGER.settingConfigFile(configFile);
        JBossWebserviceDescriptionMetaData[] wsDescriptionsMD = webservicesMD.getWebserviceDescriptions();
        PublishLocationAdapterImpl resolver = new PublishLocationAdapterImpl(wsDescriptionsMD);
        ejbArchiveMDBuilder.setPublishLocationAdapter((PublishLocationAdapter)resolver);
    }

    protected JBossPortComponentMetaData getPortComponent(String ejbName, JBossWebservicesMetaData jbossWebservicesMD) {
        if (jbossWebservicesMD == null) {
            return null;
        }
        for (JBossPortComponentMetaData jbossPortComponentMD : jbossWebservicesMD.getPortComponents()) {
            if (!ejbName.equals(jbossPortComponentMD.getEjbName())) continue;
            return jbossPortComponentMD;
        }
        return null;
    }

    protected void buildEnterpriseBeanMetaData(List<EJBMetaData> wsEjbsMD, EJBEndpoint ejbEndpoint, JBossWebservicesMetaData jbossWebservicesMD) {
        SLSBMetaData.Builder wsEjbMDBuilder = new SLSBMetaData.Builder();
        wsEjbMDBuilder.setEjbName(ejbEndpoint.getName());
        wsEjbMDBuilder.setEjbClass(ejbEndpoint.getClassName());
        JBossPortComponentMetaData portComponentMD = this.getPortComponent(ejbEndpoint.getName(), jbossWebservicesMD);
        if (portComponentMD != null) {
            wsEjbMDBuilder.setPortComponentName(portComponentMD.getPortComponentName());
            wsEjbMDBuilder.setPortComponentURI(portComponentMD.getPortComponentURI());
        }
        String authMethod = AbstractMetaDataBuilderEJB.getAuthMethod(ejbEndpoint, portComponentMD);
        String transportGuarantee = AbstractMetaDataBuilderEJB.getTransportGuarantee(ejbEndpoint, portComponentMD);
        boolean secureWsdlAccess = AbstractMetaDataBuilderEJB.isSecureWsdlAccess(ejbEndpoint, portComponentMD);
        wsEjbMDBuilder.setSecurityMetaData(new EJBSecurityMetaData(authMethod, transportGuarantee, secureWsdlAccess));
        wsEjbsMD.add((EJBMetaData)wsEjbMDBuilder.build());
    }

    private static String getAuthMethod(EJBEndpoint ejbEndpoint, JBossPortComponentMetaData portComponentMD) {
        if (ejbEndpoint.getAuthMethod() != null) {
            return ejbEndpoint.getAuthMethod();
        }
        return portComponentMD != null ? portComponentMD.getAuthMethod() : null;
    }

    private static String getTransportGuarantee(EJBEndpoint ejbEndpoint, JBossPortComponentMetaData portComponentMD) {
        if (ejbEndpoint.getTransportGuarantee() != null) {
            return ejbEndpoint.getTransportGuarantee();
        }
        return portComponentMD != null ? portComponentMD.getTransportGuarantee() : null;
    }

    private static boolean isSecureWsdlAccess(EJBEndpoint ejbEndpoint, JBossPortComponentMetaData portComponentMD) {
        if (ejbEndpoint.isSecureWsdlAccess()) {
            return true;
        }
        return portComponentMD != null && portComponentMD.getSecureWSDLAccess() != null ? portComponentMD.getSecureWSDLAccess() : false;
    }
}

