/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.metro.client;

import com.sun.xml.ws.api.client.ServiceInterceptorFactory;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import javax.xml.ws.handler.HandlerResolver;
import org.jboss.logging.Logger;
import org.jboss.wsf.spi.WSFException;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedServiceRefMetaData;
import org.jboss.wsf.stack.metro.client.HandlerResolverImpl;
import org.jboss.wsf.stack.metro.client.ServiceRefServiceInterceptorFactory;

public class ServiceObjectFactory
implements ObjectFactory {
    protected final Logger log = Logger.getLogger(ServiceObjectFactory.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
        try {
            void var14_24;
            UnifiedServiceRefMetaData serviceRef;
            block17: {
                Class<?> targetClass;
                Reference ref = (Reference)obj;
                String targetClassName = (String)ref.get("TARGET_CLASS_NAME").getContent();
                serviceRef = this.unmarshallServiceRef(ref);
                String serviceRefName = serviceRef.getServiceRefName();
                QName serviceQName = serviceRef.getServiceQName();
                String serviceImplClass = serviceRef.getServiceImplClass();
                if (serviceImplClass == null) {
                    serviceImplClass = (String)ref.get("SERVICE_CLASS_NAME").getContent();
                }
                if (Service.class.getName().equals(targetClassName)) {
                    targetClassName = serviceImplClass;
                }
                this.log.debug((Object)("getObjectInstance [name=" + serviceRefName + ",service=" + serviceImplClass + ",target=" + targetClassName + "]"));
                ClassLoader ctxLoader = Thread.currentThread().getContextClassLoader();
                Class<?> serviceClass = ctxLoader.loadClass(serviceImplClass);
                Class<?> clazz = targetClass = targetClassName != null ? ctxLoader.loadClass(targetClassName) : null;
                if (!Service.class.isAssignableFrom(serviceClass)) {
                    throw new IllegalArgumentException("WebServiceRef type '" + serviceClass + "' is not assignable to javax.xml.ws.Service");
                }
                URL wsdlURL = serviceRef.getWsdlLocation();
                ServiceRefServiceInterceptorFactory serviceInterceptorFactory = new ServiceRefServiceInterceptorFactory(serviceRef);
                try {
                    ServiceInterceptorFactory.registerForThread((ServiceInterceptorFactory)serviceInterceptorFactory);
                    if (serviceClass == Service.class) {
                        if (wsdlURL == null) throw new IllegalArgumentException("Cannot create generic javax.xml.ws.Service without wsdlLocation: " + serviceRefName);
                        Service service = Service.create((URL)wsdlURL, (QName)serviceQName);
                    } else if (wsdlURL != null) {
                        Constructor<?> ctor = serviceClass.getConstructor(URL.class, QName.class);
                        Object obj2 = ctor.newInstance(wsdlURL, serviceQName);
                    } else {
                        Service service = (Service)serviceClass.newInstance();
                    }
                    if (targetClassName == null || targetClassName.equals(serviceImplClass)) break block17;
                    try {
                        Object port = null;
                        if (serviceClass != Service.class) {
                            for (Method method : serviceClass.getDeclaredMethods()) {
                                void var14_20;
                                String methodName = method.getName();
                                Class<?> retType = method.getReturnType();
                                if (!methodName.startsWith("get") || !targetClass.isAssignableFrom(retType)) continue;
                                Object object = port = method.invoke((Object)var14_20, new Object[0]);
                                break;
                            }
                        }
                        if (port == null) {
                            void var14_22;
                            Method method = serviceClass.getMethod("getPort", Class.class);
                            Object object = port = method.invoke((Object)var14_22, targetClass);
                        }
                    }
                    catch (InvocationTargetException ex) {
                        throw ex.getTargetException();
                    }
                }
                finally {
                    ServiceInterceptorFactory.unregisterForThread((ServiceInterceptorFactory)serviceInterceptorFactory);
                }
            }
            if (serviceRef.getHandlerChain() == null || !(var14_24 instanceof Service)) return var14_24;
            ((Service)var14_24).setHandlerResolver((HandlerResolver)new HandlerResolverImpl(serviceRef.getHandlerChain(), var14_24.getClass()));
            return var14_24;
        }
        catch (Throwable ex) {
            WSFException.rethrow((String)"Cannot create service", (Throwable)ex);
            return null;
        }
    }

    private UnifiedServiceRefMetaData unmarshallServiceRef(Reference ref) throws ClassNotFoundException, NamingException {
        UnifiedServiceRefMetaData sref;
        RefAddr refAddr = ref.get("SERVICE_REF_META_DATA");
        ByteArrayInputStream bais = new ByteArrayInputStream((byte[])refAddr.getContent());
        try {
            ObjectInputStream ois = new ObjectInputStream(bais);
            sref = (UnifiedServiceRefMetaData)ois.readObject();
            ois.close();
        }
        catch (IOException e) {
            throw new NamingException("Cannot unmarshall service ref meta data, cause: " + e.toString());
        }
        if (sref.getServiceQName() == null) {
            throw new IllegalArgumentException("ServiceQName may not be null. Specify a service QName in the <service-ref> declaration, or thorugh the @WebServiceClient annotation.");
        }
        return sref;
    }
}

