/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.wsf.stack.metro.client;

import javax.xml.ws.BindingProvider;

import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedPortComponentRefMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedServiceRefMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedStubPropertyMetaData;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.client.ServiceInterceptor;
import com.sun.xml.ws.developer.WSBindingProvider;

/**
 * A ServiceInterceptor that copies properties from the unified MD
 * (for instance specified in the service-ref block of a JBoss-specific DD)
 * to the context in the BindingProvider.
 * 
 * @author alessio.soldano@jboss.com
 * @since 05-Nov-2008
 */
public class ServiceRefServiceInterceptor extends ServiceInterceptor
{
   private UnifiedServiceRefMetaData serviceRefMD;
   
   public ServiceRefServiceInterceptor(UnifiedServiceRefMetaData serviceRefMD)
   {
      this.serviceRefMD = serviceRefMD;
   }
   
   /**
    * A callback to notify the event of creation of proxy object for SEI endpoint. The
    * callback could set some properties on the {@link BindingProvider}.
    *
    * @param bp created proxy instance
    * @param serviceEndpointInterface SEI of the endpoint
    */
   @Override
   public void postCreateProxy(@NotNull WSBindingProvider bp, @NotNull Class<?> serviceEndpointInterface)
   {
      for (UnifiedPortComponentRefMetaData pcRef : serviceRefMD.getPortComponentRefs())
      {
         String sei = pcRef.getServiceEndpointInterface();
         if (sei != null && sei.equals(serviceEndpointInterface.getName()))
         {
            for (UnifiedStubPropertyMetaData prop : pcRef.getStubProperties())
            {
               bp.getRequestContext().put(prop.getPropName(), prop.getPropValue());
            }
         }
      }
   }
}
