/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.metro.client;

import com.sun.xml.ws.api.streaming.XMLStreamReaderFactory;
import com.sun.xml.ws.handler.HandlerChainsModel;
import com.sun.xml.ws.streaming.XMLStreamReaderUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.handler.PortInfo;
import org.jboss.logging.Logger;

public final class HandlerResolverImpl
implements HandlerResolver {
    private static final Logger log = Logger.getLogger(HandlerResolverImpl.class);
    private final String handlerFile;
    private final Class<?> clazz;
    private HandlerChainsModel handlerChainsModel;

    public HandlerResolverImpl(String handlerFile, Class<?> clazz) {
        this.handlerFile = handlerFile;
        this.clazz = clazz;
        this.init();
    }

    public List<Handler> getHandlerChain(PortInfo portInfo) {
        return this.handlerChainsModel.getHandlersForPortInfo(portInfo).getHandlers();
    }

    private void init() {
        InputStream is = this.getInputStream(this.handlerFile, this.clazz);
        this.handlerChainsModel = this.buildHandlerChainsModel(is, this.clazz);
    }

    private InputStream getInputStream(String filename, Class<?> wsClass) {
        URL fileURL = null;
        log.debug((Object)("processHandlerChain [" + filename + "] on: " + wsClass.getName()));
        try {
            fileURL = new URL(filename);
        }
        catch (MalformedURLException ex) {
            // empty catch block
        }
        if (fileURL == null) {
            try {
                File file = new File(filename);
                if (file.exists()) {
                    fileURL = file.toURI().toURL();
                }
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        if (fileURL == null) {
            log.debug((Object)wsClass.getProtectionDomain().getCodeSource());
            log.debug((Object)wsClass.getClassLoader());
            fileURL = wsClass.getClassLoader().getResource(filename);
        }
        if (fileURL == null) {
            String filepath = filename;
            String packagePath = wsClass.getPackage().getName().replace('.', '/');
            String resourcePath = packagePath + "/" + filepath;
            while (filepath.startsWith("../")) {
                packagePath = packagePath.substring(0, packagePath.lastIndexOf("/"));
                filepath = filepath.substring(3);
                resourcePath = packagePath + "/" + filepath;
            }
            fileURL = wsClass.getClassLoader().getResource(resourcePath);
        }
        if (fileURL == null) {
            throw new WebServiceException("Cannot resolve handler file '" + filename + "' on " + wsClass.getName());
        }
        try {
            return fileURL.openStream();
        }
        catch (IOException ioe) {
            throw new WebServiceException((Throwable)ioe);
        }
    }

    private HandlerChainsModel buildHandlerChainsModel(InputStream is, Class<?> target) {
        XMLStreamReader reader = XMLStreamReaderFactory.create(null, (InputStream)is, (boolean)true);
        XMLStreamReaderUtil.nextElementContent((XMLStreamReader)reader);
        HandlerChainsModel handlerChainsModel = HandlerChainsModel.parseHandlerConfigFile(target, (XMLStreamReader)reader);
        try {
            reader.close();
            is.close();
        }
        catch (XMLStreamException e) {
            log.error((Object)"Error while closing reader!", (Throwable)e);
            throw new WebServiceException(e.getMessage());
        }
        catch (IOException e) {
            log.error((Object)"Error while closing input stream!", (Throwable)e);
            throw new WebServiceException(e.getMessage());
        }
        return handlerChainsModel;
    }
}

