/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.metro.tools;

import com.sun.tools.ws.wscompile.WsimportTool;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jboss.wsf.spi.tools.WSContractConsumer;
import org.jboss.wsf.stack.metro.tools.NullPrintStream;

public class MetroConsumerImpl
extends WSContractConsumer {
    private List<File> bindingFiles = null;
    private File catalog = null;
    private boolean extension;
    private boolean generateSource = false;
    private File outputDir = new File("output");
    private File sourceDir = null;
    private String targetPackage = null;
    private PrintStream messageStream = null;
    private String wsdlLocation = null;
    private List<String> additionalCompilerClassPath = new ArrayList<String>();
    private boolean additionalHeaders = false;
    private String target = "2.0";
    private boolean nocompile;

    public void setBindingFiles(List<File> bindingFiles) {
        this.bindingFiles = bindingFiles;
    }

    public void setCatalog(File catalog) {
        this.catalog = catalog;
    }

    public void setExtension(boolean extension) {
        this.extension = extension;
    }

    public void setGenerateSource(boolean generateSource) {
        this.generateSource = generateSource;
    }

    public void setMessageStream(PrintStream messageStream) {
        this.messageStream = messageStream;
    }

    public void setOutputDirectory(File directory) {
        this.outputDir = directory;
    }

    public void setSourceDirectory(File directory) {
        this.sourceDir = directory;
    }

    public void setTargetPackage(String targetPackage) {
        this.targetPackage = targetPackage;
    }

    public void setWsdlLocation(String wsdlLocation) {
        this.wsdlLocation = wsdlLocation;
    }

    public void setAdditionalCompilerClassPath(List<String> additionalCompilerClassPath) {
        this.additionalCompilerClassPath = additionalCompilerClassPath;
    }

    public void setAdditionalHeaders(boolean additionalHeaders) {
        this.additionalHeaders = additionalHeaders;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setNoCompile(boolean nocompile) {
        this.nocompile = nocompile;
    }

    public void consume(URL wsdl) {
        PrintStream stream;
        ArrayList<String> args = new ArrayList<String>();
        if (this.bindingFiles != null) {
            for (File file : this.bindingFiles) {
                args.add("-b");
                args.add(file.getAbsolutePath());
            }
        }
        if (this.catalog != null) {
            args.add("-catalog");
            args.add(this.catalog.getAbsolutePath());
        }
        if (this.extension) {
            args.add("-extension");
        }
        if (this.additionalHeaders) {
            args.add("-XadditionalHeaders");
        }
        if (this.nocompile) {
            args.add("-Xnocompile");
        }
        if (this.generateSource) {
            args.add("-keep");
            if (this.sourceDir != null) {
                if (!this.sourceDir.exists() && !this.sourceDir.mkdirs()) {
                    throw new IllegalStateException("Could not make directory: " + this.sourceDir.getName());
                }
                args.add("-s");
                args.add(this.sourceDir.getAbsolutePath());
            }
        }
        if (this.targetPackage != null) {
            args.add("-p");
            args.add(this.targetPackage);
        }
        if (this.wsdlLocation != null) {
            args.add("-wsdllocation");
            args.add(this.wsdlLocation);
        }
        if ((stream = this.messageStream) != null) {
            args.add("-verbose");
        } else {
            stream = new NullPrintStream();
        }
        if (!this.outputDir.exists() && !this.outputDir.mkdirs()) {
            throw new IllegalStateException("Could not make directory: " + this.outputDir.getName());
        }
        args.add("-d");
        args.add(this.outputDir.getAbsolutePath());
        if (this.target != null) {
            if (!(this.target.equals("2.0") || this.target.equals("2.1") || this.target.equals("2.2"))) {
                throw new IllegalArgumentException("WSConsume (metro) only supports JAX-WS 2.0, 2.1 and 2.2");
            }
            args.add("-target");
            args.add(this.target);
        }
        args.add(wsdl.toString());
        if (!this.additionalCompilerClassPath.isEmpty()) {
            StringBuffer javaCP = new StringBuffer();
            for (String s : this.additionalCompilerClassPath) {
                javaCP.append(s).append(File.pathSeparator);
            }
            System.setProperty("java.class.path", javaCP.toString());
        }
        try {
            WsimportTool compileTool;
            boolean success;
            if (null == System.getProperty("javax.xml.stream.XMLInputFactory")) {
                System.setProperty("javax.xml.stream.XMLInputFactory", "com.ctc.wstx.stax.WstxInputFactory");
            }
            if (!(success = (compileTool = new WsimportTool((OutputStream)stream)).run(args.toArray(new String[0])))) {
                throw new IllegalStateException("WsImport invocation failed");
            }
        }
        catch (Throwable t) {
            if (this.messageStream != null) {
                this.messageStream.println("Failed to invoke WsImport");
                t.printStackTrace(this.messageStream);
            }
            t.printStackTrace();
        }
    }
}

