/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.metro.tools;

import com.sun.tools.ws.wscompile.WsgenTool;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.jboss.wsf.spi.tools.WSContractProvider;
import org.jboss.wsf.stack.metro.tools.NullPrintStream;

public class MetroProviderImpl
extends WSContractProvider {
    private ClassLoader loader;
    private boolean generateWsdl;
    private boolean extension;
    private boolean generateSource;
    private File outputDir = new File("output");
    private File resourceDir;
    private File sourceDir;
    private PrintStream messageStream = new NullPrintStream();

    public void setGenerateWsdl(boolean generateWsdl) {
        this.generateWsdl = generateWsdl;
    }

    public void setExtension(boolean extension) {
        this.extension = extension;
    }

    public void setGenerateSource(boolean generateSource) {
        this.generateSource = generateSource;
    }

    public void setOutputDirectory(File directory) {
        this.outputDir = directory;
    }

    public void setResourceDirectory(File directory) {
        this.resourceDir = directory;
    }

    public void setSourceDirectory(File directory) {
        this.sourceDir = directory;
    }

    public void setClassLoader(ClassLoader loader) {
        this.loader = loader;
    }

    public void setMessageStream(PrintStream messageStream) {
        this.messageStream = messageStream;
    }

    public void provide(String endpointClass) {
        try {
            this.provide(this.loader.loadClass(endpointClass));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Class not found: " + endpointClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void provide(Class<?> endpointClass) {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        if (this.loader != null) {
            Thread.currentThread().setContextClassLoader(this.loader);
        }
        try {
            String cp;
            PrintStream stream;
            File sourceDir;
            ArrayList<String> args = new ArrayList<String>();
            File resourceDir = this.resourceDir != null ? this.resourceDir : this.outputDir;
            File file = sourceDir = this.sourceDir != null ? this.sourceDir : this.outputDir;
            if (this.generateSource) {
                args.add("-keep");
                if (sourceDir != null) {
                    if (!sourceDir.exists() && !sourceDir.mkdirs()) {
                        throw new IllegalStateException("Could not make directory: " + sourceDir.getName());
                    }
                    args.add("-s");
                    args.add(sourceDir.getAbsolutePath());
                }
            }
            if (!this.outputDir.exists() && !this.outputDir.mkdirs()) {
                throw new IllegalStateException("Could not make directory: " + this.outputDir.getName());
            }
            args.add("-d");
            args.add(this.outputDir.getAbsolutePath());
            if (resourceDir != null) {
                if (!resourceDir.exists() && !resourceDir.mkdirs()) {
                    throw new IllegalStateException("Could not make directory: " + resourceDir.getName());
                }
                args.add("-r");
                args.add(resourceDir.getAbsolutePath());
            }
            if (sourceDir != null) {
                if (!sourceDir.exists() && !sourceDir.mkdirs()) {
                    throw new IllegalStateException("Could not make directory: " + sourceDir.getName());
                }
                args.add("-s");
                args.add(sourceDir.getAbsolutePath());
            }
            if ((stream = this.messageStream) != null) {
                args.add("-verbose");
            } else {
                stream = new NullPrintStream();
            }
            if (this.generateWsdl) {
                if (this.extension) {
                    args.add("-wsdl:Xsoap1.2");
                    args.add("-extension");
                } else {
                    args.add("-wsdl");
                }
            }
            if ((cp = this.buildClasspathString(this.loader)) != null) {
                args.add("-classpath");
                args.add(cp);
            }
            args.add(endpointClass.getCanonicalName());
            WsgenTool tool = new WsgenTool((OutputStream)this.messageStream);
            boolean success = tool.run(args.toArray(new String[0]));
            if (!success) {
                throw new RuntimeException("Wsgen invocation failed. Try the '-verbose' switch for more information");
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
    }

    private String buildClasspathString(ClassLoader cl) {
        String cp = null;
        if (cl instanceof URLClassLoader) {
            String parentPath;
            StringBuilder builder = new StringBuilder();
            URLClassLoader urlLoader = (URLClassLoader)cl;
            for (URL url : urlLoader.getURLs()) {
                builder.append(url.getPath());
                builder.append(File.pathSeparator);
            }
            if (cl.getParent() != null && (parentPath = this.buildClasspathString(cl.getParent())) != null) {
                builder.append(parentPath);
            }
            cp = builder.toString();
        }
        return cp;
    }
}

