/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.metro;

import com.sun.xml.ws.transport.http.servlet.ServletAdapter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.ws.WebServiceException;
import org.jboss.logging.Logger;
import org.jboss.wsf.common.IOUtils;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.invocation.EndpointAssociation;
import org.jboss.wsf.spi.invocation.InvocationContext;
import org.jboss.wsf.spi.invocation.RequestHandler;
import org.jboss.wsf.stack.metro.MessageStreamAdapter;
import org.jboss.wsf.stack.metro.MessageStreamContext;

class RequestHandlerImpl
implements RequestHandler {
    private static final Logger log = Logger.getLogger(RequestHandlerImpl.class);

    RequestHandlerImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleHttpRequest(Endpoint endpoint, HttpServletRequest req, HttpServletResponse res, ServletContext servletCtx) throws ServletException, IOException {
        block6: {
            ServletAdapter target = (ServletAdapter)endpoint.getAttachment(ServletAdapter.class);
            if (null == target) {
                throw new IllegalStateException("Cannot obtain ServletAdapter");
            }
            EndpointAssociation.setEndpoint((Endpoint)endpoint);
            try {
                String method = req.getMethod();
                if (method.equals("POST")) {
                    RequestHandlerImpl.doPost(target, servletCtx, req, res);
                    break block6;
                }
                if (method.equals("GET")) {
                    RequestHandlerImpl.doGet(target, req, servletCtx, res);
                    break block6;
                }
                throw new WebServiceException("Unsupported method: " + method);
            }
            finally {
                EndpointAssociation.removeEndpoint();
            }
        }
    }

    public void handleRequest(Endpoint endpoint, InputStream inStream, OutputStream outStream, InvocationContext invCtx) {
        MessageStreamAdapter adapter = (MessageStreamAdapter)((Object)endpoint.getAttachment(MessageStreamAdapter.class));
        if (adapter == null) {
            throw new IllegalStateException("Cannot obtain: " + ((Object)((Object)adapter)).getClass().getName());
        }
        try {
            EndpointAssociation.setEndpoint((Endpoint)endpoint);
            MessageStreamContext streamContext = new MessageStreamContext();
            RequestHandlerImpl.copyProperties(invCtx, streamContext);
            adapter.handle(streamContext, inStream, outStream);
        }
        catch (IOException e) {
            throw new WebServiceException("Failed to process request: " + e.getMessage(), (Throwable)e);
        }
        finally {
            EndpointAssociation.removeEndpoint();
        }
    }

    public void handleWSDLRequest(Endpoint endpoint, OutputStream outStream, InvocationContext invCtx) {
        String endpointAddress = endpoint.getAddress();
        if (endpointAddress == null) {
            throw new IllegalArgumentException("Invalid endpoint address: " + endpointAddress);
        }
        InputStream inStream = null;
        try {
            URL wsdlUrl = new URL(endpointAddress + "?wsdl");
            inStream = wsdlUrl.openStream();
            IOUtils.copyStream((OutputStream)outStream, (InputStream)inStream);
        }
        catch (IOException e) {
            throw new WebServiceException("Failed to process WSDL request: " + e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (IOException ignore) {}
            try {
                if (outStream != null) {
                    outStream.close();
                }
            }
            catch (IOException ignore) {}
        }
    }

    private static void doGet(ServletAdapter target, HttpServletRequest req, ServletContext context, HttpServletResponse res) throws ServletException {
        try {
            if (target != null) {
                String query = req.getQueryString();
                if (RequestHandlerImpl.isMetadataQuery(query)) {
                    target.publishWSDL(context, req, res);
                    return;
                }
                RequestHandlerImpl.sendResponse(405, "HTTP GET not supported", res);
            } else {
                RequestHandlerImpl.sendResponse(404, "Not found", res);
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to process GET request", (Throwable)e);
            throw new ServletException(e.getMessage());
        }
    }

    private static void doPost(ServletAdapter target, ServletContext context, HttpServletRequest req, HttpServletResponse res) {
        try {
            target.handle(context, req, res);
        }
        catch (Throwable e) {
            log.error((Object)"Failed to process POST request", e);
            res.setStatus(500);
        }
    }

    private static void copyProperties(InvocationContext invCtx, MessageStreamContext msgCtx) {
        boolean invCtxHasProps;
        boolean invCtxAvailable = invCtx != null;
        boolean bl = invCtxHasProps = invCtx.getAttachment(Properties.class) != null;
        if (invCtxAvailable && invCtxHasProps) {
            Map<String, String> msgReqCtx = msgCtx.getRequestContext();
            Properties invCtxProps = (Properties)invCtx.getAttachment(Properties.class);
            for (Object keyObject : invCtxProps.keySet()) {
                String key = (String)keyObject;
                msgReqCtx.put(key, invCtxProps.getProperty(key));
            }
        }
    }

    private static void sendResponse(int status, String message, HttpServletResponse res) throws IOException {
        res.setStatus(status);
        res.setContentType("text/plain");
        PrintWriter out = res.getWriter();
        ((Writer)out).write(message);
        ((Writer)out).close();
    }

    private static boolean isMetadataQuery(String query) {
        return query != null && (query.equals("WSDL") || query.startsWith("wsdl") || query.startsWith("xsd="));
    }
}

