/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.metro;

import java.net.URL;
import java.util.HashMap;
import javax.xml.ws.BindingType;
import org.jboss.wsf.spi.WSFRuntime;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.DeploymentAspect;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.stack.metro.metadata.sunjaxws.DDEndpoint;
import org.jboss.wsf.stack.metro.metadata.sunjaxws.DDEndpoints;

public class SunJaxwsDeploymentAspect
extends DeploymentAspect {
    public void create(Deployment dep, WSFRuntime runtime) {
        DDEndpoints ddEndpoints = (DDEndpoints)dep.getAttachment(DDEndpoints.class);
        if (ddEndpoints == null) {
            ddEndpoints = new DDEndpoints();
            for (Endpoint endpoint : dep.getService().getEndpoints()) {
                String endpointName = endpoint.getShortName();
                String targetBean = endpoint.getTargetBeanName();
                String urlPattern = endpoint.getURLPattern();
                DDEndpoint ddEndpoint = new DDEndpoint(endpointName, targetBean, urlPattern);
                Class beanClass = endpoint.getTargetBeanClass();
                BindingType bindingType = beanClass.getAnnotation(BindingType.class);
                if (bindingType != null && bindingType.value().length() > 0) {
                    String binding = bindingType.value();
                    ddEndpoint.setBinding(binding);
                    ddEndpoint.setEnableMTOM(SunJaxwsDeploymentAspect.isMtomEnabled(binding));
                }
                this.log.info((Object)("Add " + ddEndpoint));
                ddEndpoints.addEndpoint(ddEndpoint);
            }
            dep.addAttachment(DDEndpoints.class, (Object)ddEndpoints);
            SunJaxwsDeploymentAspect.putSunJaxwsConfigToDeployment(dep, ddEndpoints.createFileURL());
        }
    }

    public void destroy(Deployment dep, WSFRuntime runtime) {
        DDEndpoints dd = (DDEndpoints)dep.getAttachment(DDEndpoints.class);
        if (dd != null) {
            dd.destroyFileURL();
        }
    }

    private static void putSunJaxwsConfigToDeployment(Deployment dep, URL jaxwsConfigURL) {
        String propKey = "org.jboss.ws.webapp.ContextParameterMap";
        HashMap<String, String> contextParams = (HashMap<String, String>)dep.getProperty(propKey);
        if (contextParams == null) {
            contextParams = new HashMap<String, String>();
            dep.setProperty(propKey, contextParams);
        }
        contextParams.put("jbossws-sun-jaxws-url", jaxwsConfigURL.toExternalForm());
    }

    private static boolean isMtomEnabled(String binding) {
        return binding.equals("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true") || binding.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true");
    }
}

