/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.metro;

import java.io.IOException;
import javax.management.ObjectName;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.ws.WebServiceException;
import org.jboss.wsf.common.ObjectNameFactory;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.invocation.EndpointAssociation;
import org.jboss.wsf.spi.invocation.RequestHandler;
import org.jboss.wsf.spi.management.EndpointRegistry;
import org.jboss.wsf.spi.management.EndpointRegistryFactory;
import org.jboss.wsf.spi.management.EndpointResolver;
import org.jboss.wsf.stack.metro.WebAppResolver;

public class EndpointServlet
extends HttpServlet {
    protected Endpoint endpoint;
    protected EndpointRegistry epRegistry;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
        this.epRegistry = ((EndpointRegistryFactory)spiProvider.getSPI(EndpointRegistryFactory.class)).getEndpointRegistry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (this.endpoint == null) {
            String contextPath = req.getContextPath();
            this.initServiceEndpoint(contextPath);
        }
        try {
            EndpointAssociation.setEndpoint((Endpoint)this.endpoint);
            RequestHandler requestHandler = this.endpoint.getRequestHandler();
            requestHandler.handleHttpRequest(this.endpoint, req, res, this.getServletContext());
        }
        finally {
            EndpointAssociation.removeEndpoint();
        }
    }

    protected void initServiceEndpoint(String contextPath) {
        WebAppResolver resolver = new WebAppResolver(contextPath, this.getServletName());
        this.endpoint = this.epRegistry.resolve((EndpointResolver)resolver);
        if (this.endpoint == null) {
            ObjectName oname = ObjectNameFactory.create((String)("jboss.ws:context=" + contextPath + "," + "endpoint" + "=" + this.getServletName()));
            throw new WebServiceException("Cannot obtain endpoint for: " + oname);
        }
        Deployment dep = this.endpoint.getService().getDeployment();
        if (dep.getType() == Deployment.DeploymentType.JAXRPC_JSE || dep.getType() == Deployment.DeploymentType.JAXWS_JSE) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            dep.setRuntimeClassLoader(classLoader);
        }
    }
}

