/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.metro;

import com.sun.xml.ws.api.BindingID;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.WSFeatureList;
import com.sun.xml.ws.api.server.Container;
import com.sun.xml.ws.api.server.InstanceResolver;
import com.sun.xml.ws.api.server.Invoker;
import com.sun.xml.ws.api.server.SDDocumentSource;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.api.streaming.XMLStreamReaderFactory;
import com.sun.xml.ws.binding.WebServiceFeatureList;
import com.sun.xml.ws.handler.HandlerChainsModel;
import com.sun.xml.ws.resources.ServerMessages;
import com.sun.xml.ws.resources.WsservletMessages;
import com.sun.xml.ws.server.EndpointFactory;
import com.sun.xml.ws.server.ServerRtException;
import com.sun.xml.ws.streaming.Attributes;
import com.sun.xml.ws.streaming.TidyXMLStreamReader;
import com.sun.xml.ws.streaming.XMLStreamReaderUtil;
import com.sun.xml.ws.transport.http.DeploymentDescriptorParser;
import com.sun.xml.ws.transport.http.ResourceLoader;
import com.sun.xml.ws.util.HandlerAnnotationInfo;
import com.sun.xml.ws.util.exception.LocatableWebServiceException;
import com.sun.xml.ws.util.xml.XmlUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.MTOMFeature;
import javax.xml.ws.soap.SOAPBinding;
import org.xml.sax.EntityResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentDescriptorParserExt<A> {
    private static final Logger logger = Logger.getLogger("javax.enterprise.resource.webservices.jaxws.server.http");
    public static final String NS_RUNTIME = "http://java.sun.com/xml/ns/jax-ws/ri/runtime";
    public static final String JAXWS_WSDL_DD_DIR = "WEB-INF/wsdl";
    public static final QName QNAME_ENDPOINTS = new QName("http://java.sun.com/xml/ns/jax-ws/ri/runtime", "endpoints");
    public static final QName QNAME_ENDPOINT = new QName("http://java.sun.com/xml/ns/jax-ws/ri/runtime", "endpoint");
    public static final String ATTR_VERSION = "version";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_IMPLEMENTATION = "implementation";
    public static final String ATTR_WSDL = "wsdl";
    public static final String ATTR_SERVICE = "service";
    public static final String ATTR_PORT = "port";
    public static final String ATTR_URL_PATTERN = "url-pattern";
    public static final String ATTR_ENABLE_MTOM = "enable-mtom";
    public static final String ATTR_MTOM_THRESHOLD_VALUE = "mtom-threshold-value";
    public static final String ATTR_BINDING = "binding";
    public static final String ATTRVALUE_VERSION_1_0 = "2.0";
    private final Container container;
    private final ClassLoader classLoader;
    private final ResourceLoader loader;
    private final DeploymentDescriptorParser.AdapterFactory<A> adapterFactory;
    private static final org.jboss.logging.Logger log = org.jboss.logging.Logger.getLogger(DeploymentDescriptorParserExt.class);
    private final Set<String> names = new HashSet<String>();
    private final Map<String, SDDocumentSource> docs = new HashMap<String, SDDocumentSource>();

    public DeploymentDescriptorParserExt(ClassLoader cl, ResourceLoader loader, Container container, DeploymentDescriptorParser.AdapterFactory<A> adapterFactory) throws MalformedURLException {
        this.classLoader = cl;
        this.loader = loader;
        this.container = container;
        this.adapterFactory = adapterFactory;
        this.findDocs("/META-INF/wsdl/");
        this.findDocs("/WEB-INF/wsdl/");
        logger.fine("metadata=" + this.docs);
    }

    private void findDocs(String resourcePath) {
        try {
            URL resource = this.loader.getResource(resourcePath);
            if (resource != null) {
                log.debug((Object)("Collecting docs from " + resourcePath));
                this.collectDocs(resourcePath);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<A> parse(String systemId, InputStream is) {
        List<A> list;
        block11: {
            XMLStreamReader reader = null;
            try {
                reader = new TidyXMLStreamReader(XMLStreamReaderFactory.create((String)systemId, (InputStream)is, (boolean)true), (Closeable)is);
                XMLStreamReaderUtil.nextElementContent((XMLStreamReader)reader);
                list = this.parseAdapters(reader);
                if (reader == null) break block11;
            }
            catch (Throwable throwable) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (XMLStreamException e) {
                        throw new ServerRtException("runtime.parser.xmlReader", new Object[]{e});
                    }
                }
                try {
                    is.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                reader.close();
            }
            catch (XMLStreamException e) {
                throw new ServerRtException("runtime.parser.xmlReader", new Object[]{e});
            }
        }
        try {
            is.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<A> parse(File f) throws IOException {
        FileInputStream in = new FileInputStream(f);
        try {
            List<A> list = this.parse(f.getPath(), in);
            return list;
        }
        finally {
            in.close();
        }
    }

    private void collectDocs(String dirPath) throws MalformedURLException {
        Set paths = this.loader.getResourcePaths(dirPath);
        if (paths != null) {
            for (String path : paths) {
                if (path.endsWith("/")) {
                    this.collectDocs(path);
                    continue;
                }
                URL res = this.loader.getResource(path);
                this.docs.put(res.toString(), SDDocumentSource.create((URL)res));
            }
        }
    }

    private List<A> parseAdapters(XMLStreamReader reader) {
        if (!reader.getName().equals(QNAME_ENDPOINTS)) {
            DeploymentDescriptorParserExt.failWithFullName("runtime.parser.invalidElement", reader);
        }
        ArrayList<Object> adapters = new ArrayList<Object>();
        Attributes attrs = XMLStreamReaderUtil.getAttributes((XMLStreamReader)reader);
        String version = DeploymentDescriptorParserExt.getMandatoryNonEmptyAttribute(reader, attrs, ATTR_VERSION);
        if (!version.equals(ATTRVALUE_VERSION_1_0)) {
            DeploymentDescriptorParserExt.failWithLocalName("runtime.parser.invalidVersionNumber", reader, version);
        }
        while (XMLStreamReaderUtil.nextElementContent((XMLStreamReader)reader) != 2) {
            if (reader.getName().equals(QNAME_ENDPOINT)) {
                QName portName;
                attrs = XMLStreamReaderUtil.getAttributes((XMLStreamReader)reader);
                String name = DeploymentDescriptorParserExt.getMandatoryNonEmptyAttribute(reader, attrs, ATTR_NAME);
                if (!this.names.add(name)) {
                    logger.warning(WsservletMessages.SERVLET_WARNING_DUPLICATE_ENDPOINT_NAME());
                }
                String implementationName = DeploymentDescriptorParserExt.getMandatoryNonEmptyAttribute(reader, attrs, ATTR_IMPLEMENTATION);
                Class<?> implementorClass = DeploymentDescriptorParserExt.getImplementorClass(implementationName, reader, this.classLoader);
                EndpointFactory.verifyImplementorClass(implementorClass);
                SDDocumentSource primaryWSDL = DeploymentDescriptorParserExt.getPrimaryWSDL(reader, attrs, implementorClass, this.loader, this.docs);
                QName serviceName = DeploymentDescriptorParserExt.getQNameAttribute(attrs, ATTR_SERVICE);
                if (serviceName == null) {
                    serviceName = EndpointFactory.getDefaultServiceName(implementorClass);
                }
                if ((portName = DeploymentDescriptorParserExt.getQNameAttribute(attrs, ATTR_PORT)) == null) {
                    portName = EndpointFactory.getDefaultPortName((QName)serviceName, implementorClass);
                }
                String enable_mtom = DeploymentDescriptorParserExt.getAttribute(attrs, ATTR_ENABLE_MTOM);
                String mtomThreshold = DeploymentDescriptorParserExt.getAttribute(attrs, ATTR_MTOM_THRESHOLD_VALUE);
                String bindingId = DeploymentDescriptorParserExt.getAttribute(attrs, ATTR_BINDING);
                if (bindingId != null) {
                    bindingId = DeploymentDescriptorParserExt.getBindingIdForToken(bindingId);
                }
                WSBinding binding = DeploymentDescriptorParserExt.createBinding(bindingId, implementorClass, enable_mtom, mtomThreshold);
                String urlPattern = DeploymentDescriptorParserExt.getMandatoryNonEmptyAttribute(reader, attrs, ATTR_URL_PATTERN);
                boolean handlersSetInDD = DeploymentDescriptorParserExt.setHandlersAndRoles(binding, reader, serviceName, portName, this.classLoader);
                DeploymentDescriptorParserExt.ensureNoContent(reader);
                Invoker invoker = this.createInvoker(implementorClass);
                WSEndpoint endpoint = WSEndpoint.create(implementorClass, (!handlersSetInDD ? 1 : 0) != 0, (Invoker)invoker, (QName)serviceName, (QName)portName, (Container)this.container, (WSBinding)binding, (SDDocumentSource)primaryWSDL, this.docs.values(), (EntityResolver)DeploymentDescriptorParserExt.createEntityResolver(this.loader), (boolean)false);
                adapters.add(this.adapterFactory.createAdapter(name, urlPattern, endpoint));
                continue;
            }
            DeploymentDescriptorParserExt.failWithLocalName("runtime.parser.invalidElement", reader);
        }
        return adapters;
    }

    protected Invoker createInvoker(Class<?> implementorClass) {
        Invoker invoker = InstanceResolver.createDefault(implementorClass).createInvoker();
        return invoker;
    }

    private static WSBinding createBinding(String ddBindingId, Class<?> implClass, String mtomEnabled, String mtomThreshold) {
        WebServiceFeatureList features;
        BindingID bindingID;
        MTOMFeature mtomfeature = null;
        if (mtomEnabled != null) {
            mtomfeature = mtomThreshold != null ? new MTOMFeature(Boolean.valueOf(mtomEnabled).booleanValue(), Integer.valueOf(mtomThreshold).intValue()) : new MTOMFeature(Boolean.valueOf(mtomEnabled).booleanValue());
        }
        if (ddBindingId != null) {
            bindingID = BindingID.parse((String)ddBindingId);
            features = bindingID.createBuiltinFeatureList();
            if (DeploymentDescriptorParserExt.checkMtomConflict((MTOMFeature)features.get(MTOMFeature.class), mtomfeature)) {
                throw new ServerRtException(ServerMessages.DD_MTOM_CONFLICT((Object)ddBindingId, (Object)mtomEnabled), new Object[0]);
            }
        } else {
            bindingID = BindingID.parse(implClass);
            features = new WebServiceFeatureList();
            if (mtomfeature != null) {
                features.add((WebServiceFeature)mtomfeature);
            }
            features.addAll((WSFeatureList)bindingID.createBuiltinFeatureList());
        }
        return bindingID.createBinding(features.toArray());
    }

    private static boolean checkMtomConflict(MTOMFeature lhs, MTOMFeature rhs) {
        if (lhs == null || rhs == null) {
            return false;
        }
        return lhs.isEnabled() ^ rhs.isEnabled();
    }

    private static String getBindingIdForToken(String lexical) {
        if (lexical.equals("##SOAP11_HTTP")) {
            return "http://schemas.xmlsoap.org/wsdl/soap/http";
        }
        if (lexical.equals("##SOAP11_HTTP_MTOM")) {
            return "http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true";
        }
        if (lexical.equals("##SOAP12_HTTP")) {
            return "http://www.w3.org/2003/05/soap/bindings/HTTP/";
        }
        if (lexical.equals("##SOAP12_HTTP_MTOM")) {
            return "http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true";
        }
        if (lexical.equals("##XML_HTTP")) {
            return "http://www.w3.org/2004/08/wsdl/http";
        }
        return lexical;
    }

    private static SDDocumentSource getPrimaryWSDL(XMLStreamReader xsr, Attributes attrs, Class<?> implementorClass, ResourceLoader loader, Map<String, SDDocumentSource> docs) {
        String wsdlFile = DeploymentDescriptorParserExt.getAttribute(attrs, ATTR_WSDL);
        if (wsdlFile == null) {
            wsdlFile = EndpointFactory.getWsdlLocation(implementorClass);
        }
        if (wsdlFile != null) {
            URL wsdl = null;
            try {
                wsdl = loader.getResource(wsdlFile);
            }
            catch (MalformedURLException ignore) {
                // empty catch block
            }
            if (wsdl == null) {
                throw new LocatableWebServiceException(ServerMessages.RUNTIME_PARSER_WSDL_NOT_FOUND((Object)wsdlFile), xsr);
            }
            docs.put(wsdl.toExternalForm(), SDDocumentSource.create((URL)wsdl));
            SDDocumentSource docInfo = docs.get(wsdl.toExternalForm());
            assert (docInfo != null);
            return docInfo;
        }
        return null;
    }

    private static EntityResolver createEntityResolver(ResourceLoader loader) {
        try {
            return XmlUtil.createEntityResolver((URL)loader.getCatalogFile());
        }
        catch (MalformedURLException e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    private static String getAttribute(Attributes attrs, String name) {
        String value = attrs.getValue(name);
        if (value != null) {
            value = value.trim();
        }
        return value;
    }

    private static QName getQNameAttribute(Attributes attrs, String name) {
        String value = DeploymentDescriptorParserExt.getAttribute(attrs, name);
        if (value == null || value.equals("")) {
            return null;
        }
        return QName.valueOf(value);
    }

    private static String getMandatoryNonEmptyAttribute(XMLStreamReader reader, Attributes attributes, String name) {
        String value = DeploymentDescriptorParserExt.getAttribute(attributes, name);
        if (value == null) {
            DeploymentDescriptorParserExt.failWithLocalName("runtime.parser.missing.attribute", reader, name);
        } else if (value.equals("")) {
            DeploymentDescriptorParserExt.failWithLocalName("runtime.parser.invalidAttributeValue", reader, name);
        }
        return value;
    }

    private static boolean setHandlersAndRoles(WSBinding binding, XMLStreamReader reader, QName serviceName, QName portName, ClassLoader classLoader) {
        if (XMLStreamReaderUtil.nextElementContent((XMLStreamReader)reader) == 2 || !reader.getName().equals(HandlerChainsModel.QNAME_HANDLER_CHAINS)) {
            return false;
        }
        HandlerAnnotationInfo handlerInfo = HandlerChainsModel.parseHandlerFile((XMLStreamReader)reader, (ClassLoader)classLoader, (QName)serviceName, (QName)portName, (WSBinding)binding);
        binding.setHandlerChain(handlerInfo.getHandlers());
        if (binding instanceof SOAPBinding) {
            ((SOAPBinding)binding).setRoles(handlerInfo.getRoles());
        }
        XMLStreamReaderUtil.nextContent((XMLStreamReader)reader);
        return true;
    }

    private static void ensureNoContent(XMLStreamReader reader) {
        if (reader.getEventType() != 2) {
            DeploymentDescriptorParserExt.fail("runtime.parser.unexpectedContent", reader);
        }
    }

    private static void fail(String key, XMLStreamReader reader) {
        logger.log(Level.SEVERE, key + reader.getLocation().getLineNumber());
        throw new ServerRtException(key, new Object[]{Integer.toString(reader.getLocation().getLineNumber())});
    }

    private static void failWithFullName(String key, XMLStreamReader reader) {
        throw new ServerRtException(key, new Object[]{reader.getLocation().getLineNumber(), reader.getName()});
    }

    private static void failWithLocalName(String key, XMLStreamReader reader) {
        throw new ServerRtException(key, new Object[]{reader.getLocation().getLineNumber(), reader.getLocalName()});
    }

    private static void failWithLocalName(String key, XMLStreamReader reader, String arg) {
        throw new ServerRtException(key, new Object[]{reader.getLocation().getLineNumber(), reader.getLocalName(), arg});
    }

    private static Class<?> getImplementorClass(String name, XMLStreamReader reader, ClassLoader classLoader) {
        try {
            return Class.forName(name, true, classLoader);
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            throw new LocatableWebServiceException(ServerMessages.RUNTIME_PARSER_CLASS_NOT_FOUND((Object)name), (Throwable)e, reader);
        }
    }
}

