/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.metro.log;

import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Pipe;
import com.sun.xml.ws.api.pipe.PipeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractFilterPipeImpl;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.logging.Logger;

public class DumpPipe
extends AbstractFilterPipeImpl {
    private static Logger msgLog = Logger.getLogger((String)"org.jboss.wsf.spi.MessageTrace");
    private final String name;
    private final PrintStream out;
    private final XMLOutputFactory staxOut;

    public DumpPipe(String name, PrintStream out, Pipe next) {
        super(next);
        this.name = name;
        this.out = out;
        this.staxOut = XMLOutputFactory.newInstance();
    }

    public DumpPipe(PrintStream out, Pipe next) {
        this("DumpPipe", out, next);
    }

    private DumpPipe(DumpPipe that, PipeCloner cloner) {
        super((AbstractFilterPipeImpl)that, cloner);
        this.name = that.name;
        this.out = that.out;
        this.staxOut = that.staxOut;
    }

    public Packet process(Packet packet) {
        this.dump("request", packet);
        Packet reply = this.next.process(packet);
        this.dump("response", reply);
        return reply;
    }

    private void dump(String header, Packet packet) {
        if (!msgLog.isTraceEnabled()) {
            return;
        }
        msgLog.trace((Object)("====[" + this.name + ":" + header + "]===="));
        if (packet.getMessage() == null) {
            msgLog.trace((Object)"(none)");
        } else {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            try {
                XMLStreamWriter writer = this.staxOut.createXMLStreamWriter(new PrintStream(bout){

                    public void close() {
                    }
                });
                writer = this.createIndenter(writer);
                packet.getMessage().copy().writeTo(writer);
                writer.close();
            }
            catch (XMLStreamException e) {
                e.printStackTrace(new PrintStream(bout));
            }
            msgLog.trace((Object)new String(bout.toByteArray()));
        }
        msgLog.trace((Object)"============");
    }

    private XMLStreamWriter createIndenter(XMLStreamWriter writer) {
        try {
            Class<?> clazz = ((Object)((Object)this)).getClass().getClassLoader().loadClass("javanet.staxutils.IndentingXMLStreamWriter");
            Constructor<?> c = clazz.getConstructor(XMLStreamWriter.class);
            writer = (XMLStreamWriter)c.newInstance(writer);
        }
        catch (Exception e) {
            msgLog.warn((Object)"WARNING: put stax-utils.jar to the classpath to indent dumped output");
        }
        return writer;
    }

    public Pipe copy(PipeCloner cloner) {
        return new DumpPipe(this, cloner);
    }

    public void preDestroy() {
    }
}

